/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

final class EncryptedDocumentInputStream
extends InputStream {
    private final DocumentInputStream m_dis;
    private final int m_mask;

    public EncryptedDocumentInputStream(DocumentEntry documentEntry, int n) throws IOException {
        this.m_dis = new DocumentInputStream(documentEntry);
        this.m_mask = n;
    }

    public int read() throws IOException {
        int n = this.m_dis.read();
        return n ^= this.m_mask;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.m_dis.read(byArray, n, n2);
        for (int i = 0; i < n2; ++i) {
            int n4 = i + n;
            byArray[n4] = (byte)(byArray[n4] ^ this.m_mask);
        }
        return n3;
    }

    public int available() {
        try {
            return this.m_dis.available();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    public void close() {
        try {
            this.m_dis.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized void mark(int n) {
        this.m_dis.mark(n);
    }

    public boolean markSupported() {
        return this.m_dis.markSupported();
    }

    public synchronized void reset() {
        this.m_dis.reset();
    }

    public long skip(long l) throws IOException {
        return this.m_dis.skip(l);
    }
}

