/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.utility.EnumUtility;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResourceType implements MpxjEnum
{
    MATERIAL(0, "Material"),
    WORK(1, "Work"),
    COST(2, "Cost");

    private static final ResourceType[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private ResourceType(int n2, String string2) {
        this.m_value = n2;
        this.m_name = string2;
    }

    public static ResourceType getInstance(int n) {
        if (n < 0 || n >= TYPE_VALUES.length) {
            n = WORK.getValue();
        }
        return TYPE_VALUES[n];
    }

    public static ResourceType getInstance(Number number) {
        int n = number == null ? -1 : NumberUtility.getInt(number);
        return ResourceType.getInstance(n);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String toString() {
        return this.m_name;
    }

    static {
        TYPE_VALUES = (ResourceType[])EnumUtility.createTypeArray(ResourceType.class);
    }
}

