/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.common.transfer;

import com.projity.field.Field;
import com.projity.field.FieldContext;
import com.projity.field.FieldParseException;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeFactory;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelDataFactory;
import com.projity.options.EditOption;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheetModel;
import com.projity.pm.resource.ResourcePool;
import com.projity.pm.task.Project;
import com.projity.pm.task.Task;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;

public class NodeListTransferable
implements Transferable {
    private static final int NODE_LIST = 0;
    private static final int STRING = 1;
    private static final int PLAIN_TEXT = 2;
    public static final String NODE_LIST_MIME_TYPE = "application/x-java-jvm-local-objectref;class=java.util.ArrayList";
    private DataFlavor[] flavors;
    private DataFlavor nodeListDataFlavor;
    private Set flavorSet;
    protected ArrayList nodeList;
    protected ArrayList fields;
    protected SpreadSheet spreadsheet;
    protected int[] rows;
    protected int[] cols;
    protected boolean nodeSelection;

    public NodeListTransferable(ArrayList arrayList, ArrayList arrayList2, SpreadSheet spreadSheet, int[] nArray, int[] nArray2, boolean bl) {
        this.nodeSelection = bl;
        try {
            this.nodeListDataFlavor = new DataFlavor(NODE_LIST_MIME_TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (bl) {
            this.flavors = new DataFlavor[]{this.nodeListDataFlavor, DataFlavor.stringFlavor, DataFlavor.getTextPlainUnicodeFlavor()};
            this.nodeList = arrayList;
            this.fields = arrayList2;
        } else {
            this.flavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.getTextPlainUnicodeFlavor()};
        }
        this.flavorSet = new HashSet();
        CollectionUtils.addAll((Collection)this.flavorSet, this.flavors);
        this.spreadsheet = spreadSheet;
        this.rows = nArray;
        this.cols = nArray2;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.flavors.clone();
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < this.flavors.length; ++i) {
            if (!dataFlavor.equals(this.flavors[i])) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.flavorSet.contains(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (this.nodeListDataFlavor.equals(dataFlavor)) {
            NodeModel nodeModel = ((CommonSpreadSheetModel)this.spreadsheet.getModel()).getCache().getModel();
            return nodeModel.copy(this.nodeList, 0);
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return NodeListTransferable.selectionToString(this.spreadsheet, this.rows, this.cols);
        }
        if (DataFlavor.getTextPlainUnicodeFlavor().equals(dataFlavor)) {
            return new StringReader(NodeListTransferable.selectionToString(this.spreadsheet, this.rows, this.cols));
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public static String nodeListToString(List list, SpreadSheet spreadSheet, List list2) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NodeListTransferable.nodeToString((Node)iterator.next(), stringBuffer, spreadSheet, list2);
        }
        return stringBuffer.toString();
    }

    public static void nodeToString(Node node, StringBuffer stringBuffer, SpreadSheet spreadSheet, List list) {
        CommonSpreadSheetModel commonSpreadSheetModel = (CommonSpreadSheetModel)spreadSheet.getModel();
        Iterator iterator = list.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            Object object = field.getValue(node, commonSpreadSheetModel.getCache().getWalkersModel(), commonSpreadSheetModel.getFieldContext());
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append('\t');
            }
            stringBuffer.append(object == null ? "" : object.toString());
        }
        stringBuffer.append('\n');
        ListIterator listIterator = node.childrenIterator();
        while (listIterator.hasNext()) {
            NodeListTransferable.nodeToString((Node)listIterator.next(), stringBuffer, spreadSheet, list);
        }
    }

    public static String selectionToString(SpreadSheet spreadSheet, int[] nArray, int[] nArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                Object object = spreadSheet.getValueAt(nArray[i], nArray2[j]);
                if (object != null && !(object instanceof Task)) {
                    if (object instanceof Date) {
                        stringBuffer.append(EditOption.getInstance().getDateFormat().format((Date)object));
                    } else {
                        stringBuffer.append(object.toString());
                    }
                }
                if (j < nArray2.length - 1) {
                    stringBuffer.append('\t');
                    continue;
                }
                stringBuffer.append('\n');
            }
        }
        return stringBuffer.toString();
    }

    public static ArrayList stringToNodeList(String string, SpreadSheet spreadSheet, List list, NodeModelDataFactory nodeModelDataFactory) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            Node node = NodeListTransferable.stringToNode(stringTokenizer.nextToken(), spreadSheet, list, nodeModelDataFactory);
            if (node == null) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public static Node stringToNode(String string, SpreadSheet spreadSheet, List list, NodeModelDataFactory nodeModelDataFactory) {
        String string2 = spreadSheet.getSpreadSheetCategory();
        Node node = null;
        String string3 = "\t";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3, true);
        if (stringTokenizer.hasMoreTokens()) {
            if ("taskSpreadsheet".equals(string2)) {
                node = NodeFactory.getInstance().createTask((Project)nodeModelDataFactory);
            } else if ("resourceSpreadsheet".equals(string2)) {
                node = NodeFactory.getInstance().createResource((ResourcePool)nodeModelDataFactory);
            } else {
                return null;
            }
            CommonSpreadSheetModel commonSpreadSheetModel = (CommonSpreadSheetModel)spreadSheet.getModel();
            Iterator iterator = list.iterator();
            while (stringTokenizer.hasMoreTokens() && iterator.hasNext()) {
                String string4 = stringTokenizer.nextToken();
                if (string3.equals(string4)) {
                    string4 = "";
                } else if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
                Field field = (Field)iterator.next();
                try {
                    field.setValue(node, commonSpreadSheetModel.getCache().getWalkersModel(), spreadSheet, string4, commonSpreadSheetModel.getFieldContext());
                }
                catch (FieldParseException fieldParseException) {}
            }
        }
        return node;
    }

    public static void pasteString(String string, SpreadSheet spreadSheet) {
        int[] nArray = spreadSheet.getSelectedRows();
        int[] nArray2 = spreadSheet.getSelectedColumns();
        if (nArray.length > 0 && nArray2.length > 0) {
            NodeListTransferable.pasteString(string, spreadSheet, nArray[0], nArray2[0]);
        }
    }

    public static void pasteString(String string, SpreadSheet spreadSheet, int n, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n3 = n;
        while (stringTokenizer.hasMoreTokens()) {
            NodeListTransferable.pasteStringLine(stringTokenizer.nextToken(), spreadSheet, n3++, n2);
        }
    }

    public static void pasteStringLine(String string, SpreadSheet spreadSheet, int n, int n2) {
        CommonSpreadSheetModel commonSpreadSheetModel = (CommonSpreadSheetModel)spreadSheet.getModel();
        String string2 = "\t";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        int n3 = n2;
        int n4 = spreadSheet.getColumnCount() - 1;
        FieldContext fieldContext = commonSpreadSheetModel.getFieldContext();
        boolean bl = fieldContext.isRound();
        fieldContext.setRound(true);
        while (stringTokenizer.hasMoreTokens() && n3 <= n4) {
            String string3 = stringTokenizer.nextToken();
            if (string2.equals(string3)) {
                string3 = "";
            } else if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            try {
                commonSpreadSheetModel.setValueAt(string3, n, ++n3);
            }
            catch (Exception exception) {}
        }
        fieldContext.setRound(bl);
    }
}

