/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.calendar;

import com.projity.datatype.Duration;
import com.projity.pm.calendar.InvalidCalendarIntersectionException;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.calendar.WorkDay;
import com.projity.pm.calendar.WorkWeek;
import com.projity.pm.calendar.WorkingHours;
import com.projity.pm.criticalpath.CriticalPath;
import com.projity.server.access.ErrorLogger;
import com.projity.util.DateTime;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class CalendarDefinition
implements WorkCalendar,
Cloneable {
    static final long serialVersionUID = 73883742020831L;
    TreeSet dayExceptions = null;
    WorkDay[] exceptions = null;
    WorkWeek week = new WorkWeek();
    protected long id = -1L;
    transient boolean newId = true;
    private transient boolean dirty;

    public CalendarDefinition() {
        this.dayExceptions = new TreeSet();
    }

    public CalendarDefinition(CalendarDefinition calendarDefinition, CalendarDefinition calendarDefinition2) {
        this.week = calendarDefinition == null ? new WorkWeek() : (WorkWeek)calendarDefinition.week.clone();
        this.week.addDaysFrom(calendarDefinition2.week);
        this.dayExceptions = (TreeSet)calendarDefinition2.dayExceptions.clone();
        if (calendarDefinition != null) {
            this.dayExceptions.addAll(calendarDefinition.dayExceptions);
        }
        this.addSentinelsAndMakeArray();
        if (!this.testValid()) {
            System.out.println("calendar is invalid " + this.getName());
        }
    }

    public boolean testValid() {
        if (this.week == null) {
            return false;
        }
        for (int i = 0; i < 7; ++i) {
            if (this.week.getWeekDay(i) != null) continue;
            return false;
        }
        return true;
    }

    void addSentinelsAndMakeArray() {
        this.dayExceptions.add(WorkDay.MINIMUM);
        this.dayExceptions.add(WorkDay.MAXIMUM);
        this.exceptions = new WorkDay[this.dayExceptions.size()];
        this.dayExceptions.toArray(this.exceptions);
    }

    public WorkDay[] getExceptions() {
        return this.exceptions;
    }

    public WorkDay getWeekDay(int n) {
        return this.week.getWeekDay(n);
    }

    void addOrReplaceException(WorkDay workDay) {
        this.dayExceptions.remove(workDay);
        this.dayExceptions.add(workDay);
        this.exceptions = new WorkDay[this.dayExceptions.size()];
        this.dayExceptions.toArray(this.exceptions);
    }

    public Object clone() throws CloneNotSupportedException {
        CalendarDefinition calendarDefinition = (CalendarDefinition)super.clone();
        calendarDefinition.week = (WorkWeek)this.week.clone();
        calendarDefinition.dayExceptions = new TreeSet();
        Iterator iterator = this.dayExceptions.iterator();
        while (iterator.hasNext()) {
            calendarDefinition.dayExceptions.add(((WorkDay)iterator.next()).clone());
        }
        return calendarDefinition;
    }

    public long adjustInsideCalendar(long l, boolean bl) {
        long l2;
        if (l < 0L) {
            l = -l;
            boolean bl2 = bl = !bl;
        }
        if (bl) {
            long l3 = this.add(l, -60000L, bl);
            l2 = this.add(l3, 60000L, bl);
        } else {
            long l4 = this.add(l, 60000L, bl);
            l2 = this.add(l4, -60000L, bl);
        }
        return l2;
    }

    public long add(long l, long l2, boolean bl) {
        if (l == 0L) {
            return 0L;
        }
        long l3 = l;
        boolean bl2 = true;
        boolean bl3 = l < 0L;
        boolean bl4 = Duration.isElapsed(l2);
        l2 = Duration.millis(l2);
        if (bl3) {
            l = -l;
            l2 = -l2;
            boolean bl5 = bl = !bl;
            if (l2 == 0L) {
                bl2 = false;
            }
        }
        if (bl4) {
            l3 = this.adjustInsideCalendar(l + l2, bl);
        } else {
            long l4;
            if (l2 < 0L) {
                bl2 = false;
                l2 = -l2;
            }
            CalendarIterator calendarIterator = CalendarIteratorFactory.getInstance();
            long l5 = calendarIterator.dayOf(l);
            calendarIterator.initialize(this, bl2, l5);
            WorkingHours workingHours = calendarIterator.getNext(l5);
            l2 -= workingHours.calcWorkTime(calendarIterator.timeOf(l), bl2);
            int n = 0;
            long l6 = this.week.getDuration();
            while ((l4 = l2 / l6) != 0L && n++ != 4) {
                l5 = calendarIterator.nextDay(l5);
                l5 = calendarIterator.moveNumberOfDays((int)(7L * (bl2 ? l4 : -l4)), l5);
                l2 -= l4 * l6;
                if ((l2 -= calendarIterator.exceptionDurationDifference(l5)) <= 0L) {
                    calendarIterator.reverseDirection();
                    l2 = -l2;
                    bl2 = !bl2;
                    continue;
                }
                l5 = calendarIterator.prevDay(l5);
            }
            while (l2 >= 0L && (l2 != 0L || bl2 != bl)) {
                l5 = calendarIterator.nextDay(l5);
                workingHours = calendarIterator.getNext(l5);
                l2 -= workingHours.getDuration();
            }
            long l7 = -1L;
            while ((l7 = bl2 ? workingHours.calcTimeAtRemainingWork(-l2) : workingHours.calcTimeAtWork(-l2)) == -1L) {
                l5 = calendarIterator.nextDay(l5);
                workingHours = calendarIterator.getNext(l5);
            }
            l3 = l5 + l7;
            CalendarIteratorFactory.recycle(calendarIterator);
        }
        if (bl3) {
            l3 = -l3;
        }
        return l3;
    }

    public long compare(long l, long l2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = l < 0L;
        if (bl2) {
            l = -l;
            l2 = -l2;
        }
        if (bl) {
            return l - l2;
        }
        long l3 = 0L;
        if (l < l2) {
            l3 = l2;
            l2 = l;
            l = l3;
        }
        if (l2 == 0L) {
            return l;
        }
        CalendarIterator calendarIterator = CalendarIteratorFactory.getInstance();
        long l4 = calendarIterator.dayOf(l2);
        long l5 = calendarIterator.dayOf(l);
        calendarIterator.initialize(this, true, l4);
        WorkingHours workingHours = calendarIterator.getNext(l4);
        long l6 = 0L;
        l6 += workingHours.calcWorkTimeAfter(calendarIterator.timeOf(l2));
        long l7 = calendarIterator.nextDay(l4);
        long l8 = (calendarIterator.dayOf(l) - l7) / 604800000L;
        if (l8 != 0L) {
            l7 = calendarIterator.moveNumberOfDays((int)(7L * l8), l7);
            l6 += l8 * this.week.getDuration();
            l6 += calendarIterator.exceptionDurationDifference(l7);
        }
        while (l7 <= l5) {
            workingHours = calendarIterator.getNext(l7);
            l6 += workingHours.getDuration();
            l7 = calendarIterator.nextDay(l7);
        }
        l6 -= workingHours.calcWorkTimeAfter(calendarIterator.timeOf(l));
        CalendarIteratorFactory.recycle(calendarIterator);
        if (bl2) {
            l6 = -l6;
        }
        return l3 == 0L ? l6 : -l6;
    }

    public String getName() {
        return null;
    }

    public String getCategory() {
        return null;
    }

    public void setName(String string) {
    }

    public CalendarDefinition getConcreteInstance() {
        return this;
    }

    public static final int getDayOfWeek(long l) {
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(l);
        return gregorianCalendar.get(7) - 1;
    }

    public final WorkDay getWorkDay(long l) {
        WorkDay workDay = null;
        int n = Arrays.binarySearch(this.getConcreteInstance().exceptions, new Date(l));
        workDay = n >= 0 ? this.exceptions[n] : this.week.getWeekDay(CalendarDefinition.getDayOfWeek(l));
        return workDay;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getUniqueId() {
        return this.id;
    }

    public void setUniqueId(long l) {
        this.id = l;
    }

    public boolean isNew() {
        return this.newId;
    }

    public void setNew(boolean bl) {
        this.newId = bl;
    }

    public WorkCalendar getBaseCalendar() {
        return null;
    }

    public boolean dependsOn(WorkCalendar workCalendar) {
        return false;
    }

    public void invalidate() {
    }

    public boolean isInvalid() {
        return false;
    }

    CalendarDefinition intersectWith(CalendarDefinition calendarDefinition) throws InvalidCalendarIntersectionException {
        WorkDay workDay;
        int n;
        CalendarDefinition calendarDefinition2 = new CalendarDefinition();
        calendarDefinition2.week = this.week.intersectWith(calendarDefinition.week);
        for (n = 0; n < this.exceptions.length; ++n) {
            workDay = this.exceptions[n];
            calendarDefinition2.dayExceptions.add(workDay.intersectWith(calendarDefinition.getWorkDay(workDay.getStart())));
        }
        for (n = 0; n < calendarDefinition.exceptions.length; ++n) {
            workDay = calendarDefinition.exceptions[n];
            calendarDefinition2.dayExceptions.add(workDay.intersectWith(this.getWorkDay(workDay.getStart())));
        }
        calendarDefinition2.addSentinelsAndMakeArray();
        return calendarDefinition2;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public String dump() {
        int n;
        String string = "Calendar " + this.getName() + "\n";
        string = string + "weekdays\n";
        for (n = 0; n < 7; ++n) {
            string = string + "day[" + n + "]" + this.getWeekDay(n) + "\n";
        }
        string = string + "There are " + this.exceptions.length + " exceptions\n";
        for (n = 0; n < this.exceptions.length; ++n) {
            string = string + "exception" + this.exceptions[n].toString();
        }
        return string;
    }

    private static class CalendarIterator {
        WorkDay[] exceptions;
        WorkWeek week;
        Calendar scratchDate = DateTime.calendarInstance();
        long exceptionDay;
        int i;
        boolean forward;
        int step;
        private static SimpleDateFormat f = DateTime.dateFormatInstance();

        private CalendarIterator() {
        }

        private void reverseDirection() {
            this.i = this.forward ? --this.i : ++this.i;
            this.step = -this.step;
            this.exceptionDay = this.exceptions[this.i].getStart();
            this.forward = !this.forward;
        }

        public long dayOf(long l) {
            this.scratchDate.setTimeInMillis(l);
            this.scratchDate.set(11, 0);
            this.scratchDate.set(12, 0);
            this.scratchDate.set(13, 0);
            return this.scratchDate.getTimeInMillis();
        }

        public long timeOf(long l) {
            return l - this.dayOf(l);
        }

        private void initialize(CalendarDefinition calendarDefinition, boolean bl, long l) {
            this.exceptions = calendarDefinition.exceptions;
            this.week = calendarDefinition.week;
            this.forward = bl;
            this.scratchDate.setTimeInMillis(l);
            try {
                DateUtils.truncate(this.scratchDate, 5);
            }
            catch (Exception exception) {
                ErrorLogger.logOnce("hugedate", "date value is garbage " + this.scratchDate + "\n" + CriticalPath.getTrace(), exception);
            }
            this.step = bl ? 1 : -1;
            this.i = Arrays.binarySearch(this.exceptions, this.scratchDate);
            if (this.i < 0) {
                this.i = -this.i - 1;
                if (!bl) {
                    --this.i;
                }
            }
            this.exceptionDay = this.exceptions[this.i].getStart();
        }

        public String dump() {
            int n;
            String string = "CalendarIterator ";
            string = string + "weekdays\n";
            for (n = 0; n < 7; ++n) {
                string = string + "day[" + n + "]" + this.week.getWeekDay(n) + "\n";
            }
            string = string + "There are " + this.exceptions.length + " exceptions\n";
            for (n = 0; n < this.exceptions.length; ++n) {
                string = string + "exception" + this.exceptions[n].toString();
            }
            return string;
        }

        private WorkingHours getNext(long l) {
            WorkDay workDay;
            if (l == this.exceptionDay) {
                workDay = this.exceptions[this.i];
                this.i += this.step;
                if (this.i < 0 || this.i == this.exceptions.length) {
                    System.out.println("invalid calendar iterator - index is negative or past bounds. avoiding");
                    ErrorLogger.logOnce("CalendarIterator", "invalid calendar iterator i=" + this.i + "\n" + CriticalPath.getTrace(), null);
                } else {
                    this.exceptionDay = this.exceptions[this.i].getStart();
                }
            } else {
                workDay = this.week.getWeekDay(this.dayOfWeek(l));
            }
            return workDay.getWorkingHours();
        }

        private long exceptionDurationDifference(long l) {
            long l2 = 0L;
            if (this.exceptions.length == 2) {
                return 0L;
            }
            while (this.forward && this.exceptionDay < l || !this.forward && this.exceptionDay > l) {
                l2 -= this.week.getWeekDay(this.dayOfWeek(this.exceptionDay)).getDuration();
                l2 += this.exceptions[this.i].getDuration();
                this.i += this.step;
                if (this.i < 0 || this.i >= this.exceptions.length) break;
                this.exceptionDay = this.exceptions[this.i].getStart();
            }
            return l2;
        }

        private int dayOfWeek(long l) {
            this.scratchDate.setTimeInMillis(l);
            return this.scratchDate.get(7) - 1;
        }

        private long moveNumberOfDays(int n, long l) {
            this.scratchDate.setTimeInMillis(l);
            this.scratchDate.add(5, n);
            return this.scratchDate.getTimeInMillis();
        }

        private long nextDay(long l) {
            this.scratchDate.setTimeInMillis(l);
            this.scratchDate.add(5, this.forward ? 1 : -1);
            return this.scratchDate.getTimeInMillis();
        }

        private long prevDay(long l) {
            this.scratchDate.setTimeInMillis(l);
            this.scratchDate.add(5, this.forward ? -1 : 1);
            return this.scratchDate.getTimeInMillis();
        }
    }

    private static class CalendarIteratorFactory
    extends BasePoolableObjectFactory {
        private static GenericObjectPool pool = new GenericObjectPool(new CalendarIteratorFactory());

        private CalendarIteratorFactory() {
        }

        public Object makeObject() {
            return new CalendarIterator();
        }

        public static CalendarIterator getInstance() {
            try {
                return (CalendarIterator)pool.borrowObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public static void recycle(CalendarIterator calendarIterator) {
            try {
                pool.returnObject(calendarIterator);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

