//
// RSACipherImpl.h
//
// $Id: //poco/1.4/Crypto/include/Poco/Crypto/RSACipherImpl.h#1 $
//
// Library: Crypto
// Package: RSA
// Module:  RSACipherImpl
//
// Definition of the RSACipherImpl class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Crypto_RSACipherImpl_INCLUDED
#define Crypto_RSACipherImpl_INCLUDED


#include "Poco/Crypto/Crypto.h"
#include "Poco/Crypto/Cipher.h"
#include "Poco/Crypto/RSAKey.h"
#include <openssl/evp.h>


namespace Poco {
namespace Crypto {


class RSACipherImpl: public Cipher
	/// An implementation of the Cipher class for 
	/// assymetric (public-private key) encryption
	/// based on the the RSA algorithm in OpenSSL's 
	/// crypto library.
	///
	/// Encryption is using the public key, decryption
	/// requires the private key.
{
public:
	RSACipherImpl(const RSAKey& key, RSAPaddingMode paddingMode);
		/// Creates a new RSACipherImpl object for the given RSAKey
		/// and using the given padding mode.

	virtual ~RSACipherImpl();
		/// Destroys the RSACipherImpl.

	const std::string& name() const;
		/// Returns the name of the Cipher.
	
	CryptoTransform* createEncryptor();
		/// Creates an encrytor object.

	CryptoTransform* createDecryptor();
		/// Creates a decrytor object.

private:
	RSAKey _key;
	RSAPaddingMode _paddingMode;
};


//
// Inlines
//
inline const std::string& RSACipherImpl::name() const
{
	return _key.name();
}


} } // namespace Poco::Crypto


#endif // Crypto_RSACipherImpl_INCLUDED
