/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * The original contributor of this 
 *
 */

/*
 * Query.java
 *
 * Created on April 18, 2007, 5:51 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.databinding.pim;

import java.util.Date;
import java.util.Enumeration;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;
import javax.microedition.pim.ToDoList;

/**
 *
 * @author Michal Skvor
 */
class Query {
    
    public static final int STRING_TYPE     = 0;
    public static final int INTEGER_TYPE    = 1;
    public static final int BOOLEAN_TYPE    = 2;
    public static final int DATE_TYPE       = 3;
 
    public static int getListCount( int pimList ) {
        PIMList l = null;
        int count = 0;
        try {
            l = (PIMList) PIM.getInstance().openPIMList( pimList, PIM.READ_ONLY );

            for( Enumeration list = l.items(); list.hasMoreElements(); list.nextElement(), count++ );

        } catch( PIMException ex ) {
            ex.printStackTrace();                
        } finally {
            if( l != null ) {
                try { l.close(); } catch( PIMException e ) {}
            }
        }
        return count;
    }
    
    public static boolean isSupportedField( int pimList, int field ) {
        PIMList todos = null;
        boolean result = false;
        try {
            todos = (PIMList) PIM.getInstance().openPIMList( pimList, PIM.READ_ONLY );

            result = todos.isSupportedField( field );

        } catch (PIMException ex) {
            ex.printStackTrace();                
        } finally {
            if( todos != null ) {
                try { todos.close(); } catch( PIMException e ) {}
            }
        }
        return result;
    }
    
    public static int getFieldCount( int pimList, int pimIndex, int field ) {
        PIMList l = null;
        int count = 0;
        try {
            l = (PIMList) PIM.getInstance().openPIMList( pimList, PIM.READ_ONLY );

            int i = 0;

            for( Enumeration list = l.items(); list.hasMoreElements(); i++ ) {
                PIMItem todo = (PIMItem) list.nextElement();
                if( pimIndex == i ) {
                    count = todo.countValues( field );
                    break;
                }
            }
        } catch (PIMException ex) {
            ex.printStackTrace();                
        } finally {
            if( l != null ) {
                try { l.close(); } catch( PIMException e ) {}
            }
        }
        return count;
    }
    
    /**
     * @param pimList which list will be used ( PIM.TODO, PIM.CONTACT_LIST )
     * @param pimIndex
     * @param field
     * @param index
     * @param fieldType type of the field (Query.STRING_TYPE, Query.INTEGER_TYPE )
     */
    public static Object getField( int pimList, int pimIndex, int field, int index, int fieldType ) {
        PIMList l = null;
        Object result = null;
        try {
            l = (PIMList) PIM.getInstance().openPIMList( pimList, PIM.READ_ONLY );

            int i = 0;
            for( Enumeration list = l.items(); list.hasMoreElements(); i++ ) {
                PIMItem todo = (PIMItem) list.nextElement();
                if( index > todo.countValues( field ) - 1 ) {
                    throw new IllegalArgumentException( "Field index is out of scope : " + index );
                }
                if( pimIndex == i ) {
                    switch( fieldType ) {
                        case STRING_TYPE:
                            result = todo.getString( field, index );
                            break;
                        case INTEGER_TYPE:
                            result = new Integer( todo.getInt( field, index ));
                            break;
                        case BOOLEAN_TYPE:
                            result = new Boolean( todo.getBoolean( field, index ));
                            break;
                        case DATE_TYPE:
                            result = new Date( todo.getDate( field, index ));
                            break;
                        default:
                            throw new IllegalArgumentException( "Illegal field type" );
                    }
                    break;
                }
            }
        } catch (PIMException ex) {
            ex.printStackTrace();                
        } finally {
            if( l != null ) {
                try { l.close(); } catch( PIMException e ) {}
            }
        }
        return result;
    }
    
    public static void setField( int pimList, int pimIndex, int field, int index, int fieldType, Object value ) {
        PIMList l = null;
        try {
            l = (PIMList) PIM.getInstance().openPIMList( pimList, PIM.READ_WRITE );

            int i = 0;                
            for( Enumeration list = l.items(); list.hasMoreElements(); i++ ) {
                PIMItem todo = (PIMItem) list.nextElement();
                if( pimIndex == i ) {
                    switch( fieldType ) {
                        case STRING_TYPE:
                            todo.setString( field, index, PIMItem.ATTR_NONE, (String)value );
                            break;
                        case INTEGER_TYPE:
                            todo.setInt( field, index, PIMItem.ATTR_NONE, ((Integer) value ).intValue());
                            break;
                        case BOOLEAN_TYPE:
                            todo.setBoolean( field, index, PIMItem.ATTR_NONE, ((Boolean) value ).booleanValue());
                            break;
                        case DATE_TYPE:
                            todo.setDate( field, index, PIMItem.ATTR_NONE, ((Date) value ).getTime());
                            break;
                        default:
                            throw new IllegalArgumentException( "Illegal field type" );
                    }
                    todo.commit();
                    break;
                }
            }
        } catch (PIMException ex) {
            ex.printStackTrace();                
        } finally {
            if( l != null ) {
                try { l.close(); } catch( PIMException e ) {}
            }
        }
    }
        
    public static int[] getSupportedArrayElements( int pimList, int pimIndex, int field ) {
        PIMList l = null;
        int[] result = new int[0];
        try {
            l = (ToDoList) PIM.getInstance().openPIMList( pimList, PIM.READ_ONLY );
     
            int i = 0;
        } catch (PIMException ex) {
            ex.printStackTrace();                
        } finally {
            if( l != null ) {
                try { l.close(); } catch( PIMException e ) {}
            }
        }
        return result;
    }
    
    /**
     * Gets value from contact array types
     * @param contactIndex index of the contact in the list
     * @param attribute of the field
     * @param fieldID for which the query will be done
     * @param arrayFieldIndex array field index
     * @return value of the given field
     */
    public static String getContactArrayValue( int contactIndex, int attribute, int fieldID, int arrayFieldIndex ) {
        String result = null;
        ContactList contacts = null;
        try {
            contacts = (ContactList) PIM.getInstance().openPIMList( PIM.CONTACT_LIST, PIM.READ_ONLY );
            Enumeration items = contacts.items();
            for( int i = 0; items.hasMoreElements(); i++ ) {
                Contact contact = (Contact) items.nextElement();
                if( i == contactIndex ) {
                    String field[] = contact.getStringArray( fieldID, attribute );
                    result = field[ arrayFieldIndex ];
                    break;
                }
            }            
        } catch( PIMException e ) {
            e.printStackTrace();
        } finally {
            if( contacts != null )
                try { contacts.close(); } catch( PIMException e ) {}
        }
        return result;
    }
    
    /**
     * Sets value for item in the array field of the contact list
     * @param contactIndex index of the contact in the list
     * @param attribute of the field
     * @param fieldID for which the query will be done
     * @param arrayFieldIndex array field index
     * @param value of the field for set
     */
    public static void setContactArrayValue( int contactIndex, int attribute, int fieldID, int arrayFieldIndex, String value ) {
        ContactList contacts = null;
        try {
            contacts = (ContactList) PIM.getInstance().openPIMList( PIM.CONTACT_LIST, PIM.READ_WRITE );
            Enumeration items = contacts.items();
            for( int i = 0; items.hasMoreElements(); i++ ) {
                Contact contact = (Contact) items.nextElement();
                if( i == contactIndex ) {
                    String field[] = contact.getStringArray( fieldID, attribute );
                    field[ arrayFieldIndex ] = value;
                    break;
                }
            }            
        } catch( PIMException e ) {
            e.printStackTrace();
        } finally {
            if( contacts != null )
                try { contacts.close(); } catch( PIMException e ) {}
        }
    }    
}
