/**
* <h2> <span> Summary </span></h2>
* <p><b>Core Function</b>
* </p><p>Evaluates an argument to determine if it is not a number.
* </p>
* <h2> <span> Syntax </span></h2>
* <p><code>
* isNaN(<i>testValue</i>)
* </code>
* </p>
* <h2> <span> Parameters </span></h2>
* <dl><dt style="font-weight:bold"> <code>testValue</code></dt><dd> The value you want to evaluate.
* </dd></dl>
* <h2> <span> Description </span></h2>
* <p><code>isNaN</code> is a top-level function and is not associated with any object.
* </p><p><code>isNaN</code> attempts to convert the passed parameter to a number. If the parameter can't be converted, it returns true; otherwise, it returns false.
* </p><p>This function is useful because the value <code><a href="Core_JavaScript_1.5_Reference:Global_Objects:Number:NaN" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:Number:NaN">NaN</a></code> cannot be meaningfully tested with the equality operators. <code>x == NaN</code> and <code>x === NaN</code> are always false, regardless of what <code>x</code> is, even if <code>x</code> is <code>NaN</code>. For example, both <code>1 == NaN</code> and <code>NaN == NaN</code> return <code>false</code>.
* </p>
* <h2> <span> Examples </span></h2>
* <pre style="background:#EEEEEE none repeat scroll 0% 50%;border:1px solid #666666;padding:5px 5px" xml:space="preserve">isNaN(NaN) //returns true
* isNaN("string") //returns true
* isNaN("12") //returns false
* isNaN(12) //returns false
* </pre>
* <h2> <span> See also </span></h2>
* <p><a href="Number:NaN" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:Number:NaN">Number.NaN</a>,
* <a href="parseFloat" shape="rect" title="Core JavaScript 1.5 Reference:Global Functions:parseFloat">parseFloat</a>,
* <a href="parseInt" shape="rect" title="Core JavaScript 1.5 Reference:Global Functions:parseInt">parseInt</a>
* </p>
* 
* <ul style="list-style-type:none;font-size:0.9em;text-align:center">
* <li id="f-copyright">Content is available under <a href="http://developer.mozilla.org/en/docs/MDC:Copyrights" shape="rect" title="MDC:Copyrights">these licenses</a>.</li>	  		<li id="f-about"><a href="http://developer.mozilla.org/en/docs/MDC:About" shape="rect" title="MDC:About">About MDC</a></li>	  				</ul>
*/
var IsNaN = {
  // This is just a stub for a builtin native JavaScript object.
};
/**
* <h2> <span> Summary </span></h2>
* <p><b>Core Function</b>
* </p><p>Evaluates an argument to determine if it is not a number.
* </p>
* <h2> <span> Syntax </span></h2>
* <p><code>
* isNaN(<i>testValue</i>)
* </code>
* </p>
* <h2> <span> Parameters </span></h2>
* <dl><dt style="font-weight:bold"> <code>testValue</code></dt><dd> The value you want to evaluate.
* </dd></dl>
* <h2> <span> Description </span></h2>
* <p><code>isNaN</code> is a top-level function and is not associated with any object.
* </p><p><code>isNaN</code> attempts to convert the passed parameter to a number. If the parameter can't be converted, it returns true; otherwise, it returns false.
* </p><p>This function is useful because the value <code><a href="Core_JavaScript_1.5_Reference:Global_Objects:Number:NaN" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:Number:NaN">NaN</a></code> cannot be meaningfully tested with the equality operators. <code>x == NaN</code> and <code>x === NaN</code> are always false, regardless of what <code>x</code> is, even if <code>x</code> is <code>NaN</code>. For example, both <code>1 == NaN</code> and <code>NaN == NaN</code> return <code>false</code>.
* </p>
* <h2> <span> Examples </span></h2>
* <pre style="background:#EEEEEE none repeat scroll 0% 50%;border:1px solid #666666;padding:5px 5px" xml:space="preserve">isNaN(NaN) //returns true
* isNaN("string") //returns true
* isNaN("12") //returns false
* isNaN(12) //returns false
* </pre>
* <h2> <span> See also </span></h2>
* <p><a href="Number:NaN" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:Number:NaN">Number.NaN</a>,
* <a href="parseFloat" shape="rect" title="Core JavaScript 1.5 Reference:Global Functions:parseFloat">parseFloat</a>,
* <a href="parseInt" shape="rect" title="Core JavaScript 1.5 Reference:Global Functions:parseInt">parseInt</a>
* </p>
* 
* <ul style="list-style-type:none;font-size:0.9em;text-align:center">
* <li id="f-copyright">Content is available under <a href="http://developer.mozilla.org/en/docs/MDC:Copyrights" shape="rect" title="MDC:Copyrights">these licenses</a>.</li>	  		<li id="f-about"><a href="http://developer.mozilla.org/en/docs/MDC:About" shape="rect" title="MDC:About">About MDC</a></li>	  				</ul>
*/
function isNaN(testValue) {};

