/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.ide;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.xml.sax.SAXException;

public class MonitorSupport {
    private static final Logger LOGGER = Logger.getLogger(MonitorSupport.class.getName());
    public static final String MONITOR_ENABLED_PROPERTY_NAME = "monitor_enabled";
    private static final String MONITOR_MODULE_NAME = "org.netbeans.modules.web.monitor";
    private static ModuleInfo httpMonitorInfo;
    private static ModuleSpy monitorSpy;
    private static Lookup.Result res;
    private static MonitorInfoListener monitorInfoListener;
    private static MonitorLookupListener monitorLookupListener;
    private static final String MONITOR_FILTER_NAME = "HTTPMonitorFilter";
    private static final String MONITOR_FILTER_CLASS = "org.netbeans.modules.web.monitor.server.MonitorFilter";
    private static final String MONITOR_FILTER_PATTERN = "/*";
    private static final String MONITOR_INTERNALPORT_PARAM_NAME = "netbeans.monitor.ide";

    public static void setMonitorFlag(String string, boolean bl) {
        InstanceProperties instanceProperties = InstanceProperties.getInstanceProperties((String)string);
        instanceProperties.setProperty(MONITOR_ENABLED_PROPERTY_NAME, Boolean.toString(bl));
    }

    public static boolean getMonitorFlag(String string) {
        InstanceProperties instanceProperties = InstanceProperties.getInstanceProperties((String)string);
        String string2 = instanceProperties.getProperty(MONITOR_ENABLED_PROPERTY_NAME);
        return string2 == null ? true : Boolean.valueOf(string2);
    }

    public static void setMonitorFlag(TomcatManager tomcatManager, boolean bl) {
        MonitorSupport.setMonitorFlag(tomcatManager.getUri(), bl);
    }

    public static boolean getMonitorFlag(TomcatManager tomcatManager) {
        return MonitorSupport.getMonitorFlag(tomcatManager.getUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void synchronizeMonitorWithFlag(TomcatManager tomcatManager, boolean bl) throws IOException, SAXException {
        String string = tomcatManager.getUri();
        boolean bl2 = MonitorSupport.getMonitorFlag(string);
        boolean bl3 = MonitorSupport.isMonitorEnabled();
        boolean bl4 = bl3 && bl2;
        File file = MonitorSupport.getDefaultWebXML(tomcatManager);
        if (file == null) {
            Logger.getLogger(MonitorSupport.class.getName()).log(Level.INFO, null, new Exception(string));
            return;
        }
        WebApp webApp = DDProvider.getDefault().getDDRoot(file);
        if (webApp == null) {
            Logger.getLogger(MonitorSupport.class.getName()).log(Level.INFO, null, new Exception(string));
            return;
        }
        boolean bl5 = false;
        if (bl4) {
            MonitorSupport.addMonitorJars(tomcatManager);
            boolean bl6 = MonitorSupport.changeFilterMonitor(webApp, true);
            boolean bl7 = bl5 = bl5 || bl6;
            if (bl) {
                bl6 = MonitorSupport.specifyFilterPortParameter(webApp);
                bl5 = bl5 || bl6;
            }
        } else {
            boolean bl8 = MonitorSupport.changeFilterMonitor(webApp, false);
            boolean bl9 = bl5 = bl5 || bl8;
        }
        if (bl5) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                webApp.write((OutputStream)fileOutputStream);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    private static File getDefaultWebXML(TomcatManager tomcatManager) {
        File file = tomcatManager.getTomcatProperties().getCatalinaDir();
        File file2 = new File(file, "conf" + File.separator + "web.xml");
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    private static void addMonitorJars(TomcatManager tomcatManager) throws IOException {
        File file = tomcatManager.getTomcatProperties().getCatalinaHome();
        if (file == null) {
            return;
        }
        File file2 = tomcatManager.getTomcatProperties().getMonitorLibFolder();
        MonitorSupport.copyFromIDEInstToDir("modules/ext/org-netbeans-modules-web-httpmonitor.jar", new File(file2, "org-netbeans-modules-web-httpmonitor.jar"));
        MonitorSupport.copyFromIDEInstToDir("modules/org-netbeans-modules-schema2beans.jar", new File(file2, "org-netbeans-modules-schema2beans.jar"));
    }

    private static boolean changeFilterMonitor(WebApp webApp, boolean bl) {
        boolean bl2;
        block12: {
            block11: {
                int n;
                bl2 = false;
                if (!bl) break block11;
                boolean bl3 = false;
                Filter[] filterArray = webApp.getFilter();
                for (n = 0; n < filterArray.length; ++n) {
                    if (!filterArray[n].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    try {
                        Filter filter = (Filter)webApp.createBean("Filter");
                        filter.setFilterName(MONITOR_FILTER_NAME);
                        filter.setFilterClass(MONITOR_FILTER_CLASS);
                        webApp.addFilter(filter);
                        bl2 = true;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                n = 0;
                FilterMapping[] filterMappingArray = webApp.getFilterMapping();
                for (int i = 0; i < filterMappingArray.length; ++i) {
                    if (!filterMappingArray[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                    n = 1;
                    break;
                }
                if (n != 0) break block12;
                try {
                    FilterMapping filterMapping = (FilterMapping)webApp.createBean("FilterMapping");
                    Object[] objectArray = new String[]{"REQUEST", "FORWARD", "INCLUDE", "ERROR"};
                    try {
                        filterMapping.setDispatcher((String[])objectArray);
                    }
                    catch (VersionNotSupportedException versionNotSupportedException) {
                        ((BaseBean)filterMapping).createProperty("dispatcher", "Dispatcher", 65840, String.class);
                        ((BaseBean)filterMapping).setValue("Dispatcher", objectArray);
                    }
                    filterMapping.setFilterName(MONITOR_FILTER_NAME);
                    filterMapping.setUrlPattern(MONITOR_FILTER_PATTERN);
                    webApp.addFilterMapping(filterMapping);
                    bl2 = true;
                }
                catch (ClassNotFoundException classNotFoundException) {}
                break block12;
            }
            FilterMapping[] filterMappingArray = webApp.getFilterMapping();
            for (int i = 0; i < filterMappingArray.length; ++i) {
                if (!filterMappingArray[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                webApp.removeFilterMapping(filterMappingArray[i]);
                bl2 = true;
                break;
            }
            Filter[] filterArray = webApp.getFilter();
            for (int i = 0; i < filterArray.length; ++i) {
                if (!filterArray[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                webApp.removeFilter(filterArray[i]);
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    private static File findInstallationFile(String string) {
        return InstalledFileLocator.getDefault().locate(string, null, false);
    }

    private static void copyFromIDEInstToDir(String string, File file) throws IOException {
        File file2 = MonitorSupport.findInstallationFile(string);
        if (file2 != null && file2.exists() && (!file.exists() || file2.length() != file.length())) {
            MonitorSupport.copy(file2, file);
        }
    }

    private static void copy(File file, File file2) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        while ((n = bufferedInputStream.read()) != -1) {
            bufferedOutputStream.write(n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    private static boolean specifyFilterPortParameter(WebApp webApp) {
        Filter[] filterArray = webApp.getFilter();
        Filter filter = null;
        for (int i = 0; i < filterArray.length; ++i) {
            if (!MONITOR_FILTER_NAME.equals(filterArray[i].getFilterName())) continue;
            filter = filterArray[i];
            break;
        }
        if (filter == null) {
            return false;
        }
        InitParam[] initParamArray = filter.getInitParam();
        InitParam initParam = null;
        for (int i = 0; i < initParamArray.length; ++i) {
            if (!MONITOR_INTERNALPORT_PARAM_NAME.equals(initParamArray[i].getParamName())) continue;
            initParam = initParamArray[i];
            break;
        }
        String string = MonitorSupport.getLocalHost() + ":" + MonitorSupport.getInternalServerPort();
        if (initParam == null) {
            try {
                InitParam initParam2 = (InitParam)filter.createBean("InitParam");
                initParam2.setParamName(MONITOR_INTERNALPORT_PARAM_NAME);
                initParam2.setParamValue(string);
                filter.addInitParam(initParam2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.log(Level.FINE, null, classNotFoundException);
            }
            return true;
        }
        if (string.equals(initParam.getParamValue())) {
            return false;
        }
        initParam.setParamValue(string);
        return true;
    }

    public static String getLocalHost() {
        return "127.0.0.1";
    }

    private static URL getSampleHTTPServerURL() {
        FileObject fileObject = FileUtil.getConfigFile((String)"HTTPServer_DUMMY");
        if (fileObject == null) {
            return null;
        }
        URL uRL = URLMapper.findURL((FileObject)fileObject, (int)2);
        return uRL;
    }

    private static String getInternalServerPort() {
        URL uRL = MonitorSupport.getSampleHTTPServerURL();
        if (uRL != null) {
            return "" + uRL.getPort();
        }
        return "8082";
    }

    private static void startModuleSpy(ModuleSpy moduleSpy) {
        res = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        Iterator iterator = res.allInstances().iterator();
        String string = moduleSpy.getModuleId();
        boolean bl = false;
        while (iterator.hasNext()) {
            ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
            if (!moduleInfo.getCodeName().startsWith(string)) continue;
            httpMonitorInfo = moduleInfo;
            moduleSpy.setEnabled(moduleInfo.isEnabled());
            monitorInfoListener = new MonitorInfoListener(moduleSpy);
            httpMonitorInfo.addPropertyChangeListener((PropertyChangeListener)monitorInfoListener);
            bl = true;
            break;
        }
        monitorLookupListener = new MonitorLookupListener(moduleSpy, httpMonitorInfo);
        res.addLookupListener((LookupListener)monitorLookupListener);
    }

    static synchronized boolean isMonitorEnabled() {
        if (monitorSpy == null) {
            monitorSpy = new ModuleSpy(MONITOR_MODULE_NAME);
            MonitorSupport.startModuleSpy(monitorSpy);
        }
        return monitorSpy.isEnabled();
    }

    void removeListeners() {
        if (httpMonitorInfo != null) {
            httpMonitorInfo.removePropertyChangeListener((PropertyChangeListener)monitorInfoListener);
        }
        if (res != null) {
            res.removeLookupListener((LookupListener)monitorLookupListener);
        }
    }

    private static class MonitorLookupListener
    implements LookupListener {
        ModuleSpy spy;
        ModuleInfo httpMonitorInfo;

        MonitorLookupListener(ModuleSpy moduleSpy, ModuleInfo moduleInfo) {
            this.spy = moduleSpy;
            this.httpMonitorInfo = moduleInfo;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Iterator iterator = res.allInstances().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
                if (!moduleInfo.getCodeName().startsWith(this.spy.getModuleId())) continue;
                this.spy.setEnabled(moduleInfo.isEnabled());
                if (this.httpMonitorInfo == null) {
                    this.httpMonitorInfo = moduleInfo;
                    MonitorSupport.monitorInfoListener = new MonitorInfoListener(this.spy);
                    this.httpMonitorInfo.addPropertyChangeListener((PropertyChangeListener)monitorInfoListener);
                }
                bl = true;
                break;
            }
            if (!bl && this.httpMonitorInfo != null) {
                this.httpMonitorInfo.removePropertyChangeListener((PropertyChangeListener)monitorInfoListener);
                this.httpMonitorInfo = null;
                this.spy.setEnabled(false);
            }
        }
    }

    private static class MonitorInfoListener
    implements PropertyChangeListener {
        ModuleSpy spy;

        MonitorInfoListener(ModuleSpy moduleSpy) {
            this.spy = moduleSpy;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                this.spy.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    private static class ModuleSpy {
        private boolean enabled;
        private String moduleId;

        public ModuleSpy(String string) {
            this.moduleId = string;
        }

        public void setModuleId(String string) {
            this.moduleId = string;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getModuleId() {
            return this.moduleId;
        }
    }
}

