/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutCache;
import org.netbeans.modules.editor.lib2.view.ViewReplace;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

final class ViewBuilder {
    private static final Logger LOG = Logger.getLogger(ViewBuilder.class.getName());
    private int prevViewEndOffset;
    private final int offsetDelta;
    private final Element lineRoot;
    private int lineIndex;
    private int lineStartOffset;
    private int lineEndOffset;
    private int paragraphViewEndOffset = Integer.MIN_VALUE;
    private int matchOffset = Integer.MIN_VALUE;
    private final FactoryState[] factoryStates;
    private final ViewReplace<DocumentView, ParagraphView> dReplace;
    private ViewReplace<ParagraphView, EditorView> fReplace;
    private ViewReplace<ParagraphView, EditorView> pReplace;
    private boolean viewRemovalFinished;
    private List<ViewReplace<ParagraphView, EditorView>> pReplaceList;
    private int docTextLength;
    private boolean createLocalViews;

    ViewBuilder(ParagraphView paragraphView, DocumentView documentView, int paragraphViewIndex, EditorViewFactory[] viewFactories, int startOffset, int endOffset, int endModOffset, int offsetDelta, boolean createLocalViews) {
        Document doc = documentView.getDocument();
        this.docTextLength = doc.getLength() + 1;
        assert (startOffset >= 0) : "startOffset=" + startOffset + " < 0";
        assert (endOffset >= endModOffset) : "endOffset=" + endOffset + " < endModOffset=" + endModOffset;
        this.createLocalViews = createLocalViews;
        assert (paragraphView == null || createLocalViews) : "createLocalViews=" + createLocalViews + ", paragraphView=" + paragraphView;
        if (paragraphView != null) {
            this.fReplace = new ViewReplace(paragraphView, paragraphView.getViewIndex(startOffset));
            this.pReplace = this.fReplace;
            ++paragraphViewIndex;
        }
        this.dReplace = new ViewReplace(documentView, paragraphViewIndex);
        int origEndOffset = offsetDelta < 0 ? endOffset + -offsetDelta : endOffset;
        int endAffectedOffset = Math.max(endModOffset, origEndOffset);
        if (this.fReplace != null) {
            int paragraphViewStartOffset = paragraphView.getStartOffset();
            assert (paragraphViewStartOffset <= startOffset) : "paragraphViewStartOffset=" + paragraphViewStartOffset + " > startOffset=" + startOffset;
            EditorView childView = this.fReplace.childViewAtIndex();
            int childStartOffset = childView.getStartOffset();
            assert (childStartOffset <= startOffset) : "childStartOffset=" + childStartOffset + " > startOffset=" + startOffset;
            startOffset = childStartOffset;
            this.paragraphViewEndOffset = paragraphViewStartOffset + paragraphView.getLength();
            if (endAffectedOffset < this.paragraphViewEndOffset) {
                this.matchOffset = startOffset;
                while (this.matchOffset < endAffectedOffset) {
                    this.matchOffset += childView.getLength();
                    ++this.fReplace.removeCount;
                    int index = this.fReplace.removeEndIndex();
                    if (index == paragraphView.getViewCount()) {
                        assert (this.matchOffset == this.paragraphViewEndOffset) : "matchOffset=" + this.matchOffset + " != paragraphViewEndOffset=" + this.paragraphViewEndOffset;
                        break;
                    }
                    childView = paragraphView.getEditorView(index);
                }
                assert (this.matchOffset >= endAffectedOffset);
            } else {
                this.fReplace.removeTillEnd();
                this.matchOffset = this.paragraphViewEndOffset;
            }
        }
        if (this.matchOffset < endAffectedOffset) {
            int paragraphCount = documentView.getViewCount();
            int index = this.dReplace.removeEndIndex();
            if (index < paragraphCount) {
                Object nextParagraphView = documentView.getEditorView(index);
                if (this.paragraphViewEndOffset == Integer.MIN_VALUE) {
                    this.paragraphViewEndOffset = ((View)nextParagraphView).getStartOffset();
                }
                this.paragraphViewEndOffset += ((EditorView)nextParagraphView).getLength();
                this.matchOffset = this.paragraphViewEndOffset;
                ++this.dReplace.removeCount;
                this.checkRemoveParagraphs(endAffectedOffset, false);
            } else {
                this.viewRemovalFinished = true;
                this.matchOffset = this.paragraphViewEndOffset = this.docTextLength;
            }
        }
        assert (this.matchOffset >= 0) : "matchOffset=" + this.matchOffset;
        assert (this.paragraphViewEndOffset >= 0) : "paragraphViewEndOffset=" + this.paragraphViewEndOffset;
        if (!this.viewRemovalFinished && offsetDelta != 0) {
            this.matchOffset += offsetDelta;
            this.paragraphViewEndOffset += offsetDelta;
        }
        assert (this.matchOffset >= 0) : "matchOffset=" + this.matchOffset;
        assert (this.paragraphViewEndOffset >= 0) : "paragraphViewEndOffset=" + this.paragraphViewEndOffset;
        this.prevViewEndOffset = startOffset;
        this.offsetDelta = offsetDelta;
        this.lineRoot = doc.getDefaultRootElement();
        this.lineIndex = this.lineRoot.getElementIndex(startOffset);
        Element line = this.lineRoot.getElement(this.lineIndex);
        this.lineStartOffset = line.getStartOffset();
        this.lineEndOffset = line.getEndOffset();
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("ViewBuilder: <").append(startOffset).append(",").append(endOffset);
            if (this.matchOffset != endOffset) {
                sb.append("=>").append(this.matchOffset);
            }
            sb.append(">, endModOffset=").append(endModOffset);
            sb.append(", docTextLength=").append(this.docTextLength).append("\nfReplace=");
            if (this.fReplace != null) {
                sb.append(this.fReplace);
            } else {
                sb.append("<NULL>\n");
            }
            sb.append("dReplace=").append(this.dReplace);
            sb.append("lineIndex=").append(this.lineIndex);
            sb.append(", lineStartOffset=").append(this.lineStartOffset);
            sb.append(", createLocalViews=").append(createLocalViews);
            sb.append('\n');
            LOG.fine(sb.toString());
        }
        this.factoryStates = new FactoryState[viewFactories.length];
        for (int i = 0; i < viewFactories.length; ++i) {
            FactoryState state = new FactoryState(viewFactories[i], startOffset);
            state.init(startOffset, this.matchOffset);
            state.updateNextViewStartOffset(startOffset);
            this.factoryStates[i] = state;
        }
        this.pReplaceList = new ArrayList<ViewReplace<ParagraphView, EditorView>>(2);
    }

    void createViews() {
        boolean doCreateViews;
        assert (this.prevViewEndOffset <= this.matchOffset) : "prevViewEndOffset=" + this.prevViewEndOffset + " > matchOffset=" + this.matchOffset;
        boolean bl = doCreateViews = this.prevViewEndOffset < this.matchOffset;
        if (this.prevViewEndOffset == this.matchOffset && this.fReplace != null) {
            assert (this.fReplace == this.pReplace);
            if (this.fReplace.added == null && this.fReplace.removeCount == ((ParagraphView)this.fReplace.view).getViewCount()) {
                assert (this.fReplace.index == 0) : "Invalid full-remove fReplace: " + this.fReplace;
                this.fReplace = null;
                this.pReplace = null;
                --this.dReplace.index;
                ++this.dReplace.removeCount;
            } else {
                boolean newlineViewRetained = this.fReplace.removeEndIndex() < ((ParagraphView)this.fReplace.view).getViewCount();
                this.checkRemoveParagraphs(this.prevViewEndOffset, newlineViewRetained);
            }
        }
        if (doCreateViews) {
            while (this.createNextView()) {
            }
        }
        if (this.pReplace != null && this.pReplace != this.fReplace) {
            throw new IllegalStateException("Unfinished non-first replace pReplace=" + this.pReplace);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("ViewBuilder-creationEndOffset=" + this.prevViewEndOffset + "\n");
        }
        if (LOG.isLoggable(Level.FINER)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finer("ViewBuilder-Original:\n" + ((DocumentView)this.dReplace.view).toStringDetail() + '\n');
            }
            StringBuilder sb = new StringBuilder(200);
            sb.append("ViewBuilder.createViews():\n");
            if (this.fReplace != null) {
                sb.append("fReplace:").append(this.fReplace);
            }
            sb.append("dReplace:").append(this.dReplace);
            sb.append("pReplaceList:\n");
            int digitCount = ArrayUtilities.digitCount((int)this.pReplaceList.size());
            for (int i = 0; i < this.pReplaceList.size(); ++i) {
                ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
                sb.append(this.pReplaceList.get(i));
            }
            LOG.fine(sb.toString());
        }
    }

    boolean createNextView() {
        int limitOffset = this.matchOffset;
        for (int i = this.factoryStates.length - 1; i >= 0; --i) {
            FactoryState state = this.factoryStates[i];
            int cmp = state.nextViewStartOffset - this.prevViewEndOffset;
            if (cmp < 0) {
                state.updateNextViewStartOffset(this.prevViewEndOffset);
                cmp = state.nextViewStartOffset - this.prevViewEndOffset;
            }
            if (cmp == 0) {
                boolean eolView;
                int createdViewEndOffset;
                assert (this.prevViewEndOffset >= 0) : "prevViewEndOffset=" + this.prevViewEndOffset + " < 0";
                assert (this.prevViewEndOffset < limitOffset) : "prevViewEndOffset=" + this.prevViewEndOffset + " >= limitOffset=" + limitOffset + ", docTextLength=" + this.docTextLength;
                assert (limitOffset <= this.docTextLength) : "limitOffset=" + limitOffset + " > docTextLength=" + this.docTextLength;
                EditorView view = null;
                if (this.createLocalViews) {
                    view = state.factory.createView(this.prevViewEndOffset, limitOffset);
                    if (view == null) continue;
                    createdViewEndOffset = this.prevViewEndOffset + view.getLength();
                } else {
                    createdViewEndOffset = state.factory.viewEndOffset(this.prevViewEndOffset, limitOffset);
                    if (createdViewEndOffset == -1) continue;
                }
                if (createdViewEndOffset > this.docTextLength) {
                    throw new IllegalStateException("View " + view + " produced by factory " + state.factory + " has endOffset=" + createdViewEndOffset + " but docTextLength=" + this.docTextLength);
                }
                this.updateLine(createdViewEndOffset);
                boolean bl = eolView = createdViewEndOffset == this.lineEndOffset;
                if (!this.viewRemovalFinished) {
                    if (this.fReplace != null && this.fReplace == this.pReplace) {
                        if (createdViewEndOffset > this.paragraphViewEndOffset || eolView) {
                            this.fReplace.removeTillEnd();
                            this.matchOffset = this.paragraphViewEndOffset;
                            this.checkRemoveParagraphs(createdViewEndOffset, eolView);
                        } else if (createdViewEndOffset > this.matchOffset) {
                            int index;
                            int viewCount = ((ParagraphView)this.fReplace.view).getViewCount();
                            while ((index = this.fReplace.removeEndIndex()) < viewCount) {
                                this.matchOffset += ((EditorView)((ParagraphView)this.pReplace.view).getEditorView(index)).getLength();
                                ++this.pReplace.removeCount;
                                if (createdViewEndOffset > this.matchOffset) continue;
                            }
                            assert (index < viewCount) : "Replace includes last local view; viewCount=" + viewCount + ", matchOffset=" + this.matchOffset + ", paragraphViewEndOffset=" + this.paragraphViewEndOffset + ", docTextLength=" + this.docTextLength;
                        }
                    } else {
                        this.checkRemoveParagraphs(createdViewEndOffset, eolView);
                    }
                }
                assert (this.viewRemovalFinished || createdViewEndOffset <= this.matchOffset) : "createdViewEndOffset=" + createdViewEndOffset + " > matchOffset=" + this.matchOffset + ", docTextLength=" + this.docTextLength;
                if (this.pReplace == null) {
                    Position startPos;
                    try {
                        startPos = ((DocumentView)this.dReplace.view).getDocument().createPosition(this.prevViewEndOffset);
                    }
                    catch (BadLocationException e) {
                        throw new IllegalStateException("Cannot create position at offset=" + this.lineStartOffset);
                    }
                    ParagraphView paragraphView = new ParagraphView(startPos);
                    this.dReplace.add(paragraphView);
                    this.pReplace = new ViewReplace(paragraphView, 0);
                    if (this.createLocalViews) {
                        this.pReplaceList.add(this.pReplace);
                    }
                }
                if (this.createLocalViews) {
                    this.pReplace.add(view);
                }
                if (eolView) {
                    if (this.fReplace != this.pReplace) {
                        int length = createdViewEndOffset - ((ParagraphView)this.pReplace.view).getStartOffset();
                        ((ParagraphView)this.pReplace.view).setLength(length);
                    }
                    this.pReplace = null;
                }
                this.prevViewEndOffset = createdViewEndOffset;
                return this.prevViewEndOffset < this.matchOffset;
            }
            if (state.nextViewStartOffset >= this.docTextLength) continue;
            limitOffset = state.nextViewStartOffset;
        }
        throw new IllegalStateException("No factory returned view for offset=" + this.prevViewEndOffset);
    }

    private void checkRemoveParagraphs(int createdViewEndOffset, boolean newlineViewCreated) {
        while (createdViewEndOffset > this.matchOffset || !newlineViewCreated && createdViewEndOffset == this.matchOffset) {
            int index = this.dReplace.removeEndIndex();
            if (index < ((DocumentView)this.dReplace.view).getViewCount()) {
                ParagraphView removeView = (ParagraphView)((DocumentView)this.dReplace.view).getEditorView(index);
                ++this.dReplace.removeCount;
                this.paragraphViewEndOffset += removeView.getLength();
                this.matchOffset = this.paragraphViewEndOffset;
                continue;
            }
            this.viewRemovalFinished = true;
            this.matchOffset = this.paragraphViewEndOffset = this.docTextLength;
            break;
        }
    }

    void repaintAndReplaceViews() {
        DocumentView docView = (DocumentView)this.dReplace.view;
        JTextComponent textComponent = docView.getTextComponent();
        assert (textComponent != null) : "Null textComponent";
        boolean docViewHeightChanged = false;
        boolean docViewWidthChanged = false;
        Rectangle repaintBounds = new Rectangle(0, 0, -1, -1);
        Rectangle2D.Double docViewBounds = docView.getAllocation();
        TextLayoutCache textLayoutCache = docView.getTextLayoutCache();
        if (this.fReplace != null) {
            Shape childAlloc;
            EditorBoxView.ReplaceResult fResult;
            if (this.fReplace.removeCount > 0) {
                textLayoutCache.remove((ParagraphView)this.fReplace.view, this.fReplace.index, this.fReplace.removeCount);
            }
            if ((fResult = this.fReplace.replaceViews(this.offsetDelta, childAlloc = docView.getChildAllocation(this.dReplace.index - 1, docViewBounds))) != null) {
                if (fResult.isPreferenceChanged()) {
                    docView.preferenceChanged(this.dReplace.index - 1, fResult.isWidthChanged(), fResult.isHeightChanged(), false);
                    docViewWidthChanged |= fResult.isWidthChanged();
                    docViewHeightChanged |= fResult.isHeightChanged();
                }
                if (!fResult.getRepaintBounds().isEmpty()) {
                    repaintBounds.add(fResult.getRepaintBounds());
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.fine("fReplace:REPAINT:" + ViewUtils.toString(fResult.getRepaintBounds()) + '\n');
                    }
                }
            }
        }
        for (int i = 0; i < this.dReplace.removeCount; ++i) {
            ParagraphView paragraphView = (ParagraphView)docView.getEditorView(this.dReplace.index + i);
            if (paragraphView.children == null) continue;
            textLayoutCache.removeParagraph(paragraphView);
        }
        EditorBoxView.ReplaceResult dResult = this.dReplace.replaceViews(0, docViewBounds);
        if (dResult != null) {
            if (dResult.isPreferenceChanged()) {
                docViewWidthChanged |= dResult.isWidthChanged();
                docViewHeightChanged |= dResult.isHeightChanged();
            }
            if (!dResult.getRepaintBounds().isEmpty()) {
                repaintBounds.add(dResult.getRepaintBounds());
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.fine("dReplace:REPAINT:" + ViewUtils.toString(dResult.getRepaintBounds()) + '\n');
                }
            }
        }
        for (int i = 0; i < this.pReplaceList.size(); ++i) {
            Shape childAlloc;
            ViewReplace<ParagraphView, EditorView> replace = this.pReplaceList.get(i);
            EditorBoxView.ReplaceResult pResult = replace.replaceViews(0, childAlloc = docView.getChildAllocation(this.dReplace.index + i, docViewBounds));
            if (pResult == null) continue;
            if (pResult.isPreferenceChanged()) {
                docView.preferenceChanged(this.dReplace.index + i, pResult.isWidthChanged(), pResult.isHeightChanged(), false);
                docViewWidthChanged |= pResult.isWidthChanged();
                docViewHeightChanged |= pResult.isHeightChanged();
            }
            if (pResult.getRepaintBounds().isEmpty()) continue;
            repaintBounds.add(pResult.getRepaintBounds());
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.fine("pReplaceList[" + i + "]:REPAINT:" + ViewUtils.toString(pResult.getRepaintBounds()) + '\n');
        }
        if (!repaintBounds.isEmpty()) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.fine("REPAINT-bounds:" + ViewUtils.toString(repaintBounds) + '\n');
            }
            ViewUtils.repaint(textComponent, repaintBounds);
        }
        if (docViewWidthChanged || docViewHeightChanged) {
            docView.preferenceChanged(null, docViewWidthChanged, docViewHeightChanged);
        }
    }

    void finish() {
        for (FactoryState factoryState : this.factoryStates) {
            factoryState.factory.finish();
        }
        ((DocumentView)this.dReplace.view).checkIntegrity();
    }

    void updateLine(int offset) {
        while (offset > this.lineEndOffset) {
            ++this.lineIndex;
            Element line = this.lineRoot.getElement(this.lineIndex);
            this.lineStartOffset = line.getStartOffset();
            this.lineEndOffset = line.getEndOffset();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("-------- ViewBuilder dump -------\n");
        sb.append("prevViewEndOffset=").append(this.prevViewEndOffset).append('\n');
        sb.append("offsetDelta=").append(this.offsetDelta).append('\n');
        sb.append("docTextLength=").append(this.docTextLength).append('\n');
        sb.append("lineIndex=").append(this.lineIndex).append('\n');
        sb.append("lineStartOffset=").append(this.lineStartOffset).append('\n');
        sb.append("lineEndOffset=").append(this.lineEndOffset).append('\n');
        sb.append("paragraphViewEndOffset=").append(this.paragraphViewEndOffset).append('\n');
        sb.append("matchOffset=").append(this.matchOffset).append('\n');
        sb.append("fReplace=").append(this.fReplace).append('\n');
        sb.append("dReplace=").append(this.dReplace).append('\n');
        sb.append("pReplace=").append(this.pReplace).append('\n');
        sb.append("pReplaceList=").append(this.pReplaceList).append('\n');
        sb.append("viewRemovalFinished=").append(this.viewRemovalFinished).append('\n');
        sb.append("-------- End of ViewBuilder dump -------\n");
        return sb.toString();
    }

    private static final class FactoryState {
        final EditorViewFactory factory;
        int nextViewStartOffset;

        FactoryState(EditorViewFactory factory, int startOffset) {
            this.factory = factory;
        }

        void init(int startOffset, int matchOffset) {
            this.factory.restart(startOffset, matchOffset);
        }

        void updateNextViewStartOffset(int offset) {
            this.nextViewStartOffset = this.factory.nextViewStartOffset(offset);
            if (this.nextViewStartOffset < offset) {
                throw new IllegalStateException("Editor view factory " + this.factory + " returned nextViewStartOffset=" + this.nextViewStartOffset + " < offset=" + offset);
            }
        }
    }
}

