/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.Collections;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingManager;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsSequenceEx;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.HighlightsView;
import org.netbeans.modules.editor.lib2.view.NewlineView;
import org.netbeans.modules.editor.lib2.view.TabView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class HighlightsViewFactory
extends EditorViewFactory
implements HighlightsChangeListener {
    private static final Logger LOG = Logger.getLogger(HighlightsViewFactory.class.getName());
    private static final boolean dumpHighlightChangeStack = Boolean.getBoolean(HighlightsViewFactory.class.getName() + ".stack");
    private static final RequestProcessor RP = new RequestProcessor("Highlights-Coalescing", 1, false, false);
    private static final boolean SYNC_HIGHLIGHTS = Boolean.getBoolean("org.netbeans.editor.sync.highlights");
    private final HighlightsContainer highlightsContainer;
    private CharSequence docText;
    private Element lineElementRoot;
    private int lineIndex;
    private int newLineOffset;
    private HighlightsSequence highlightsSequence;
    private int highlightStartOffset;
    private int highlightEndOffset;
    private AttributeSet highlightAttributes;
    private final Object dirtyRegionLock = new String("dirty-region-lock");
    private int dirtyReqionStartOffset = Integer.MAX_VALUE;
    private int dirtyReqionEndOffset = Integer.MIN_VALUE;
    private final RequestProcessor.Task dirtyRegionTask = RP.create(new Runnable(){
        private boolean insideRender = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                if (this.insideRender) {
                    int[] region = HighlightsViewFactory.this.getAndClearDirtyRegion();
                    if (region != null) {
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.fine("coallesced-event: <" + region[0] + ',' + region[1] + ">\n");
                        }
                        HighlightsViewFactory.this.fireEvent(Collections.singletonList(HighlightsViewFactory.this.createChange(region[0], region[1])));
                    }
                } else {
                    this.insideRender = true;
                    try {
                        Document doc = HighlightsViewFactory.this.textComponent().getDocument();
                        doc.render(this);
                    }
                    finally {
                        this.insideRender = false;
                    }
                }
            } else {
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
        }
    });

    public HighlightsViewFactory(JTextComponent component) {
        super(component);
        this.highlightsContainer = HighlightingManager.getInstance().getHighlights(component, null);
        this.highlightsContainer.addHighlightsChangeListener((HighlightsChangeListener)WeakListeners.create(HighlightsChangeListener.class, (EventListener)this, (Object)this.highlightsContainer));
    }

    @Override
    public void restart(int startOffset, int matchOffset) {
        Document doc = this.textComponent().getDocument();
        this.docText = DocumentUtilities.getText((Document)doc);
        this.lineElementRoot = doc.getDefaultRootElement();
        this.lineIndex = this.lineElementRoot.getElementIndex(startOffset);
        this.newLineOffset = this.lineElementRoot.getElement(this.lineIndex).getEndOffset() - 1;
        this.highlightEndOffset = Integer.MIN_VALUE;
    }

    @Override
    public int nextViewStartOffset(int offset) {
        return offset;
    }

    @Override
    public EditorView createView(int startOffset, int limitOffset) {
        this.updateHighlight(startOffset);
        this.updateNewLineOffset(startOffset);
        if (startOffset == this.newLineOffset) {
            return new NewlineView(startOffset, startOffset >= this.highlightStartOffset && startOffset + 1 <= this.highlightEndOffset ? this.highlightAttributes : null);
        }
        if (startOffset < this.highlightStartOffset) {
            int endOffset = Math.min(Math.min(this.highlightStartOffset, limitOffset), this.newLineOffset);
            return this.createHighlightsView(startOffset, endOffset - startOffset, null);
        }
        int endOffset = Math.min(Math.min(this.highlightEndOffset, limitOffset), this.newLineOffset);
        return this.createHighlightsView(startOffset, endOffset - startOffset, this.highlightAttributes);
    }

    @Override
    public int viewEndOffset(int startOffset, int limitOffset) {
        this.updateNewLineOffset(startOffset);
        return Math.min(this.newLineOffset + 1, limitOffset);
    }

    private EditorView createHighlightsView(int startOffset, int length, AttributeSet attrs) {
        if (length <= 0) {
            throw new IllegalStateException("startOffset=" + startOffset + ", length=" + length + ", highlight: <" + this.highlightStartOffset + "," + this.highlightEndOffset + ">, newLineOffset=" + this.newLineOffset + ", docText.length()=" + this.docText.length());
        }
        boolean tabs = this.docText.charAt(startOffset) == '\t';
        for (int i = 1; i < length; ++i) {
            if (tabs == (this.docText.charAt(startOffset + i) == '\t')) continue;
            length = i;
            break;
        }
        return tabs ? new TabView(startOffset, length, attrs) : new HighlightsView(startOffset, length, attrs);
    }

    private void updateHighlight(int offset) {
        while (this.highlightEndOffset <= offset) {
            this.fetchNextHighlight(offset);
        }
    }

    private void updateNewLineOffset(int offset) {
        while (this.newLineOffset < offset && this.lineIndex + 1 < this.lineElementRoot.getElementCount()) {
            ++this.lineIndex;
            this.newLineOffset = this.lineElementRoot.getElement(this.lineIndex).getEndOffset() - 1;
        }
    }

    private void fetchNextHighlight(int offset) {
        if (this.highlightsSequence == null && this.highlightEndOffset == Integer.MIN_VALUE) {
            this.highlightsSequence = this.highlightsContainer.getHighlights(offset, Integer.MAX_VALUE);
        }
        while (this.highlightsSequence != null) {
            while (this.highlightsSequence instanceof HighlightsSequenceEx && ((HighlightsSequenceEx)this.highlightsSequence).isStale()) {
                this.highlightsSequence = this.highlightsContainer.getHighlights(offset, Integer.MAX_VALUE);
            }
            if (this.highlightsSequence.moveNext()) {
                this.highlightStartOffset = this.highlightsSequence.getStartOffset();
                this.highlightEndOffset = this.highlightsSequence.getEndOffset();
                this.highlightAttributes = this.highlightsSequence.getAttributes();
                offset = this.highlightEndOffset;
                if (this.highlightStartOffset >= this.highlightEndOffset) continue;
                if (!LOG.isLoggable(Level.FINEST)) break;
                LOG.fine("Highlight: <" + this.highlightStartOffset + "," + this.highlightEndOffset + "> " + ViewUtils.toString(this.highlightAttributes) + "\n");
                break;
            }
            this.highlightsSequence = null;
            this.highlightAttributes = null;
            this.highlightStartOffset = Integer.MAX_VALUE;
            this.highlightEndOffset = Integer.MAX_VALUE;
        }
    }

    @Override
    public void finish() {
        this.docText = null;
        this.lineElementRoot = null;
        this.lineIndex = -1;
        this.newLineOffset = -1;
        this.highlightsSequence = null;
        this.highlightStartOffset = Integer.MAX_VALUE;
        this.highlightEndOffset = Integer.MAX_VALUE;
        this.highlightAttributes = null;
    }

    @Override
    public EditorViewFactory.Change insertUpdate(DocumentEvent evt) {
        return null;
    }

    @Override
    public EditorViewFactory.Change removeUpdate(DocumentEvent evt) {
        return null;
    }

    @Override
    public EditorViewFactory.Change changedUpdate(DocumentEvent evt) {
        return null;
    }

    @Override
    public void highlightChanged(HighlightsChangeEvent event) {
        int startOffset = event.getStartOffset();
        int endOffset = event.getEndOffset();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINER, "highlightChanged: event:<{0}{1}{2}>, thread:{3}\n", new Object[]{startOffset, Character.valueOf(','), endOffset, Thread.currentThread()});
            if (dumpHighlightChangeStack) {
                LOG.log(Level.INFO, "Highlight Change Thread Dump for <" + startOffset + "," + endOffset + ">", new Exception());
            }
        }
        if (endOffset > startOffset) {
            this.extendDirtyRegion(startOffset, endOffset);
            if (SYNC_HIGHLIGHTS) {
                this.dirtyRegionTask.run();
            } else {
                this.dirtyRegionTask.schedule(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extendDirtyRegion(int startOffset, int endOffset) {
        Object object = this.dirtyRegionLock;
        synchronized (object) {
            this.dirtyReqionStartOffset = Math.min(this.dirtyReqionStartOffset, startOffset);
            this.dirtyReqionEndOffset = Math.max(this.dirtyReqionEndOffset, endOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getAndClearDirtyRegion() {
        Object object = this.dirtyRegionLock;
        synchronized (object) {
            if (this.dirtyReqionStartOffset == Integer.MAX_VALUE || this.dirtyReqionEndOffset == Integer.MIN_VALUE) {
                return null;
            }
            int[] region = new int[]{this.dirtyReqionStartOffset, this.dirtyReqionEndOffset};
            this.dirtyReqionStartOffset = Integer.MAX_VALUE;
            this.dirtyReqionEndOffset = Integer.MIN_VALUE;
            return region;
        }
    }

    public static final class HighlightsFactory
    implements EditorViewFactory.Factory {
        @Override
        public EditorViewFactory createEditorViewFactory(JTextComponent component) {
            return new HighlightsViewFactory(component);
        }

        @Override
        public int importance() {
            return 0;
        }
    }
}

