/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class GemProgressPanel
extends JPanel {
    private final InputHandler inputHandler;
    private JPanel detailsPanel;
    private JScrollPane detailsScrollPane;
    private JLabel messageLabel;
    private JTextArea outputArea;
    private JCheckBox outputToggle;
    private JProgressBar progressBar;
    private OutputStream processInput;

    GemProgressPanel(String message) {
        this.initComponents();
        this.messageLabel.setText(message);
        this.inputHandler = new InputHandler();
        this.inputHandler.attach(this.outputArea);
    }

    void appendOutput(final String line) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GemProgressPanel.this.appendOutput(line);
                }
            });
            return;
        }
        if (!this.isShowing()) {
            return;
        }
        this.outputArea.setEditable(true);
        Document doc = this.outputArea.getDocument();
        if (doc != null) {
            try {
                doc.insertString(doc.getLength(), line + "\n", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    void done(String message) {
        if (!EventQueue.isDispatchThread()) {
            throw new AssertionError((Object)"#done must be called from EDT");
        }
        if (this.isShowing()) {
            this.messageLabel.setText(message);
            this.progressBar.setIndeterminate(false);
            this.progressBar.getModel().setValue(this.progressBar.getModel().getMaximum());
            this.outputArea.setEditable(false);
        }
        this.inputHandler.detach();
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        JSeparator separator = new JSeparator();
        this.outputToggle = new JCheckBox();
        this.progressBar = new JProgressBar();
        this.detailsPanel = new JPanel();
        this.detailsScrollPane = new JScrollPane();
        this.outputArea = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(GemProgressPanel.class, (String)"GemProgressPanel.messageLabel.text"));
        this.outputToggle.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.outputToggle, (String)NbBundle.getMessage(GemProgressPanel.class, (String)"GemProgressPanel.outputToggle.text"));
        this.outputToggle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.outputToggle.setEnabled(false);
        this.outputToggle.setMargin(new Insets(0, 0, 0, 0));
        this.outputToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GemProgressPanel.this.outputToggleActionPerformed(evt);
            }
        });
        this.progressBar.setIndeterminate(true);
        this.detailsPanel.setLayout(new BorderLayout());
        this.outputArea.setColumns(20);
        this.outputArea.setEditable(false);
        this.outputArea.setLineWrap(true);
        this.outputArea.setRows(6);
        this.detailsScrollPane.setViewportView(this.outputArea);
        this.outputArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GemProgressPanel.class, (String)"GemProgressPanel.outputArea.AccessibleContext.accessibleName"));
        this.outputArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GemProgressPanel.class, (String)"GemProgressPanel.outputArea.AccessibleContext.accessibleDescription"));
        this.detailsPanel.add((Component)this.detailsScrollPane, "Center");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.messageLabel).addContainerGap(389, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.progressBar, -1, 391, Short.MAX_VALUE).add(22, 22, 22)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.outputToggle).addContainerGap(303, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.detailsPanel, -1, 401, Short.MAX_VALUE).add((Component)separator, -1, 401, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.messageLabel).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addPreferredGap(0).add((Component)separator, -2, 10, -2).addPreferredGap(0).add((Component)this.outputToggle).addPreferredGap(0).add((Component)this.detailsPanel, -1, 231, Short.MAX_VALUE).addContainerGap()));
    }

    private void outputToggleActionPerformed(ActionEvent evt) {
        if (this.outputToggle.isSelected()) {
            this.detailsPanel.add((Component)this.detailsScrollPane, "Center");
        } else {
            this.detailsPanel.remove(this.detailsScrollPane);
        }
        this.detailsPanel.invalidate();
        this.invalidate();
        this.revalidate();
        this.validate();
        this.repaint();
    }

    void setProcessInput(OutputStream processInput) {
        this.processInput = processInput;
    }

    private class InputHandler
    implements KeyListener {
        private JTextComponent textComponent;
        private int startOffset;

        private InputHandler() {
        }

        private void detach() {
            this.textComponent.removeKeyListener(this);
        }

        private void attach(final JTextComponent textComponent) {
            this.textComponent = textComponent;
            textComponent.addKeyListener(this);
            if (textComponent.getDocument() instanceof AbstractDocument) {
                ((AbstractDocument)textComponent.getDocument()).setDocumentFilter(new DocumentFilter(){

                    @Override
                    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                        if (offset >= InputHandler.this.startOffset) {
                            super.insertString(fb, offset, string, attr);
                        }
                        textComponent.getCaret().setVisible(true);
                    }

                    @Override
                    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                        if (offset >= InputHandler.this.startOffset) {
                            super.remove(fb, offset, length);
                        }
                    }

                    @Override
                    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                        if (offset >= InputHandler.this.startOffset) {
                            super.replace(fb, offset, length, text, attrs);
                        }
                    }
                });
            }
        }

        private String getLastLine(Document doc) throws BadLocationException {
            StringBuilder lineBuffer = new StringBuilder();
            String c = null;
            int i = 1;
            while (!"\n".equals(c = this.getLastChar(doc, i))) {
                lineBuffer.append(c);
                ++i;
            }
            return lineBuffer.reverse().append('\n').toString();
        }

        private String getLastChar(Document doc, int endOffset) throws BadLocationException {
            return doc.getText(doc.getLength() - endOffset, 1);
        }

        private String getLastChar(Document doc) throws BadLocationException {
            return this.getLastChar(doc, 1);
        }

        @Override
        public void keyPressed(KeyEvent event) {
            try {
                switch (event.getKeyCode()) {
                    case 10: {
                        try {
                            GemProgressPanel.this.processInput.write(this.getLastLine(this.textComponent.getDocument()).getBytes());
                            GemProgressPanel.this.processInput.flush();
                        }
                        catch (IOException ioe) {
                            Exceptions.printStackTrace((Throwable)ioe);
                        }
                        break;
                    }
                    case 8: {
                        Document doc = this.textComponent.getDocument();
                        if ("\n".equals(this.getLastChar(doc))) break;
                        this.startOffset = doc.getLength() - 1;
                        doc.remove(this.startOffset, 1);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.textComponent.setCaretPosition(this.textComponent.getDocument().getLength());
            this.startOffset = this.textComponent.getDocument().getLength();
        }

        @Override
        public void keyReleased(KeyEvent ev) {
        }

        @Override
        public void keyTyped(KeyEvent ev) {
        }
    }
}

