/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.ruby.platform;

import java.io.File;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.Util;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class RubyPlatformValidator {
    private final RubyPlatform platform;

    RubyPlatformValidator(RubyPlatform platform) {
        this.platform = platform;
    }

    boolean hasRubyGemsInstalled(boolean warn) {
        String problems = this.getRubyGemsProblems();
        if (problems != null && warn) {
            Util.notifyLocalized(RubyPlatform.class, "RubyPlatformValidator.DoesNotHaveRubyGems", 2, new Object[]{this.platform.getLabel(), problems});
        }
        return problems == null;
    }

    String getRubyGemsProblems() {
        String gemTool = this.platform.getGemTool();
        if (gemTool == null) {
            return this.getGemMissingMessage();
        }
        String gemHome = this.platform.getInfo().getGemHome();
        if (gemHome == null) {
            return NbBundle.getMessage(RubyPlatformValidator.class, (String)"RubyPlatformValidator.CannotFindGemRepository");
        }
        File gemHomeF = new File(gemHome);
        if (!gemHomeF.isDirectory()) {
            return null;
        }
        return null;
    }

    boolean checkAndReportRubyGemsProblems() {
        String problems = this.getRubyGemsProblems();
        if (problems != null) {
            this.reportRubyGemsProblem();
        }
        return problems == null;
    }

    private String getGemMissingMessage() {
        String version;
        if (Utilities.isMac() && "/usr/bin/ruby".equals(this.platform.getInterpreter()) && ((version = System.getProperty("os.version")) == null || version.startsWith("10.4"))) {
            return NbBundle.getMessage(RubyPlatformValidator.class, (String)"RubyPlatformValidator.GemMissingMac");
        }
        return NbBundle.getMessage(RubyPlatformValidator.class, (String)"RubyPlatformValidator.GemMissing");
    }

    void reportRubyGemsProblem() {
        String problems = this.getRubyGemsProblems();
        assert (problems != null) : "cannot report RubyGems problems when there not any";
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)problems, 0));
    }
}

