/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.SecurityTableModel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.Util;
import org.openide.util.NbBundle;

public class PropertiesTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Name"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Value")};
    private static final String attrName = "Name";
    private static final String hibernate_prefix = "hibernate.";
    private SessionFactory sessionFactory;
    private String propCategory;
    private ArrayList<PropertyData> propsData;

    public PropertiesTableModel(SessionFactory sessionFactory, String string) {
        this.sessionFactory = sessionFactory;
        this.propCategory = string;
        this.getPropsData();
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.sessionFactory == null) {
            return null;
        }
        if (n2 == 0) {
            return this.propsData.get(n).getPropName();
        }
        return this.propsData.get(n).getPropValue();
    }

    @Override
    public int getRowCount() {
        if (this.sessionFactory == null) {
            return 0;
        }
        return this.propsData.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void addRow(String string, String string2) {
        int n = this.sessionFactory.addProperty2(string2);
        this.sessionFactory.setAttributeValue("Property2", n, attrName, string);
        this.propsData.add(new PropertyData(n, string, string2));
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void editRow(int n, String string) {
        PropertyData propertyData = this.propsData.get(n);
        this.sessionFactory.setProperty2(propertyData.getModelIndex(), string);
        propertyData.setPropValue(string);
        this.fireTableRowsUpdated(n, n);
    }

    public void removeRow(int n) {
        this.sessionFactory.removeValue("Property2", this.propsData.get(n).getModelIndex());
        this.getPropsData();
        this.fireTableRowsDeleted(n, n);
    }

    private void getPropsData() {
        this.propsData = new ArrayList();
        List<String> list = Arrays.asList(Util.getAllPropNames(this.propCategory));
        if (this.sessionFactory != null) {
            for (int i = 0; i < this.sessionFactory.sizeProperty2(); ++i) {
                String string = this.sessionFactory.getAttributeValue("Property2", i, attrName);
                if (!list.contains(string) && !list.contains(hibernate_prefix + string)) continue;
                String string2 = this.sessionFactory.getProperty2(i);
                this.propsData.add(new PropertyData(i, string, string2));
            }
        }
    }

    private class PropertyData {
        private int modelIndex;
        private String name;
        private String value;

        public PropertyData(int n, String string, String string2) {
            this.modelIndex = n;
            this.name = string;
            this.value = string2;
        }

        public int getModelIndex() {
            return this.modelIndex;
        }

        public String getPropName() {
            return this.name;
        }

        public String getPropValue() {
            return this.value;
        }

        public void setPropValue(String string) {
            this.value = string;
        }
    }
}

