/*
 * Decompiled with CFR 0.152.
 */
package org.joni.util;

import org.joni.util.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BytesHash<V>
extends Hash<V> {
    public BytesHash() {
    }

    public BytesHash(int size) {
        super(size);
    }

    public static int hashCode(byte[] bytes, int p, int end) {
        int key = 0;
        while (p < end) {
            key = (key << 16) + (key << 6) - key + bytes[p++];
        }
        key += key >> 5;
        return key;
    }

    public V put(byte[] bytes, V value) {
        return this.put(bytes, 0, bytes.length, value);
    }

    public V put(byte[] bytes, int p, int end, V value) {
        this.checkResize();
        int hash = BytesHash.hashValue(BytesHash.hashCode(bytes, p, end));
        int i = BytesHash.bucketIndex(hash, this.table.length);
        OniBytesHashEntry entry = (OniBytesHashEntry)this.table[i];
        while (entry != null) {
            if (entry.hash == hash && entry.equals(bytes, p, end)) {
                entry.value = value;
                return value;
            }
            entry = (OniBytesHashEntry)entry.next;
        }
        this.table[i] = new OniBytesHashEntry<V>(hash, this.table[i], value, bytes, p, end);
        ++this.size;
        return null;
    }

    public void putDirect(byte[] bytes, V value) {
        this.putDirect(bytes, 0, bytes.length, value);
    }

    public void putDirect(byte[] bytes, int p, int end, V value) {
        this.checkResize();
        int hash = BytesHash.hashValue(BytesHash.hashCode(bytes, p, end));
        int i = BytesHash.bucketIndex(hash, this.table.length);
        this.table[i] = new OniBytesHashEntry<V>(hash, this.table[i], value, bytes, p, end);
        ++this.size;
    }

    public V get(byte[] bytes) {
        return this.get(bytes, 0, bytes.length);
    }

    public V get(byte[] bytes, int p, int end) {
        int hash = BytesHash.hashValue(BytesHash.hashCode(bytes, p, end));
        OniBytesHashEntry entry = (OniBytesHashEntry)this.table[BytesHash.bucketIndex(hash, this.table.length)];
        while (entry != null) {
            if (entry.hash == hash && entry.equals(bytes, p, end)) {
                return (V)entry.value;
            }
            entry = (OniBytesHashEntry)entry.next;
        }
        return null;
    }

    public V delete(byte[] bytes) {
        return this.delete(bytes, 0, bytes.length);
    }

    public V delete(byte[] bytes, int p, int end) {
        int hash = BytesHash.hashValue(BytesHash.hashCode(bytes, p, end));
        int i = BytesHash.bucketIndex(hash, this.table.length);
        OniBytesHashEntry entry = (OniBytesHashEntry)this.table[i];
        if (entry == null) {
            return null;
        }
        if (entry.hash == hash && entry.equals(bytes, p, end)) {
            this.table[i] = entry.next;
            --this.size;
            return (V)entry.value;
        }
        while (entry.next != null) {
            Hash.OniHashEntry tmp = entry.next;
            if (tmp.hash == hash && entry.equals(bytes, p, end)) {
                entry.next = entry.next.next;
                --this.size;
                return tmp.value;
            }
            entry = (OniBytesHashEntry)entry.next;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OniBytesHashEntry<V>
    extends Hash.OniHashEntry<V> {
        public final byte[] bytes;
        public final int p;
        public final int end;

        public OniBytesHashEntry(int hash, Hash.OniHashEntry<V> next, V value, byte[] bytes, int p, int end) {
            super(hash, next, value);
            this.bytes = bytes;
            this.p = p;
            this.end = end;
        }

        public boolean equals(byte[] bytes, int p, int end) {
            if (this.end - this.p != end - p) {
                return false;
            }
            if (this.bytes == bytes) {
                return true;
            }
            int q = this.p;
            while (q < this.end) {
                if (this.bytes[q++] == bytes[p++]) continue;
                return false;
            }
            return true;
        }
    }
}

