/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.web.beans.impl.model.FieldInjectionPointLogic;

abstract class AbstractObjectProvider<T extends Refreshable>
implements ObjectProvider<T> {
    private AnnotationModelHelper myHelper;
    private String myAnnotationName;

    AbstractObjectProvider(String string, AnnotationModelHelper annotationModelHelper) {
        this.myHelper = annotationModelHelper;
        this.myAnnotationName = string;
    }

    public List<T> createInitialObjects() throws InterruptedException {
        final LinkedList linkedList = new LinkedList();
        this.getHelper().getAnnotationScanner().findAnnotations(this.getAnnotation(), EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE), new AnnotationHandler(){

            public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotationMirror) {
                linkedList.add(AbstractObjectProvider.this.createTypeElement(typeElement));
            }
        });
        return linkedList;
    }

    public List<T> createObjects(TypeElement typeElement) {
        if ((typeElement.getKind() == ElementKind.CLASS || typeElement.getKind() == ElementKind.INTERFACE) && this.getHelper().hasAnnotation(typeElement.getAnnotationMirrors(), this.getAnnotation())) {
            return Collections.singletonList(this.createTypeElement(typeElement));
        }
        return Collections.emptyList();
    }

    public boolean modifyObjects(TypeElement typeElement, List<T> list) {
        assert (list.size() == 1);
        Refreshable refreshable = (Refreshable)list.get(0);
        assert (refreshable != null);
        if (!refreshable.refresh(typeElement)) {
            list.remove(0);
            return true;
        }
        return false;
    }

    protected abstract T createTypeElement(TypeElement var1);

    public static List<Element> getAnnotatedMembers(String string, AnnotationModelHelper annotationModelHelper) {
        final LinkedList<Element> linkedList = new LinkedList<Element>();
        try {
            annotationModelHelper.getAnnotationScanner().findAnnotations(string, EnumSet.of(ElementKind.FIELD, ElementKind.METHOD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotationMirror) {
                    linkedList.add(element);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            FieldInjectionPointLogic.LOGGER.warning("Finding annotation " + string + " was interrupted");
        }
        return linkedList;
    }

    protected AnnotationModelHelper getHelper() {
        return this.myHelper;
    }

    protected String getAnnotation() {
        return this.myAnnotationName;
    }

    public static List<Element> getNamedMembers(AnnotationModelHelper annotationModelHelper) {
        List<Element> list = AbstractObjectProvider.getAnnotatedMembers("javax.inject.Named", annotationModelHelper);
        return list;
    }

    static interface Refreshable {
        public boolean refresh(TypeElement var1);
    }
}

