/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.spi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.javacard.spi.ICardCapability;
import org.netbeans.modules.javacard.spi.capabilities.AntTargetInterceptor;
import org.netbeans.modules.javacard.spi.capabilities.CardContentsProvider;
import org.netbeans.modules.javacard.spi.capabilities.CardCustomizerProvider;
import org.netbeans.modules.javacard.spi.capabilities.ClearEpromCapability;
import org.netbeans.modules.javacard.spi.capabilities.DebugCapability;
import org.netbeans.modules.javacard.spi.capabilities.DeleteCapability;
import org.netbeans.modules.javacard.spi.capabilities.EpromFileCapability;
import org.netbeans.modules.javacard.spi.capabilities.PortProvider;
import org.netbeans.modules.javacard.spi.capabilities.ProfileCapability;
import org.netbeans.modules.javacard.spi.capabilities.ResumeCapability;
import org.netbeans.modules.javacard.spi.capabilities.StartCapability;
import org.netbeans.modules.javacard.spi.capabilities.StopCapability;
import org.netbeans.modules.javacard.spi.capabilities.UrlCapability;

public enum DeclarableCapabilities {
    START,
    STOP,
    RESUME,
    DEBUG,
    PROFILE,
    EPROM_FILE,
    CLEAR_EPROM,
    URL,
    CONTENTS,
    PORTS,
    CUSTOMIZER,
    INTERCEPTOR,
    DELETE;


    public static final Set<? extends DeclarableCapabilities> forString(String s) {
        String[] caps = s.split(",");
        HashSet<DeclarableCapabilities> result = new HashSet<DeclarableCapabilities>(DeclarableCapabilities.values().length);
        for (String c : caps) {
            for (DeclarableCapabilities cc : DeclarableCapabilities.values()) {
                if (!cc.name().equals(c.trim())) continue;
                result.add(cc);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static String toString(Set<? extends DeclarableCapabilities> set) {
        StringBuilder sb = new StringBuilder();
        for (DeclarableCapabilities declarableCapabilities : set) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(declarableCapabilities.name());
        }
        return sb.toString();
    }

    public static Set<Class<? extends ICardCapability>> types(Set<? extends DeclarableCapabilities> set) {
        HashSet<Class<? extends ICardCapability>> result = new HashSet<Class<? extends ICardCapability>>(set.size());
        for (DeclarableCapabilities declarableCapabilities : set) {
            result.add(declarableCapabilities.type());
        }
        return result;
    }

    public Class<? extends ICardCapability> type() {
        switch (this) {
            case DEBUG: {
                return DebugCapability.class;
            }
            case PROFILE: {
                return ProfileCapability.class;
            }
            case RESUME: {
                return ResumeCapability.class;
            }
            case START: {
                return StartCapability.class;
            }
            case STOP: {
                return StopCapability.class;
            }
            case EPROM_FILE: {
                return EpromFileCapability.class;
            }
            case CLEAR_EPROM: {
                return ClearEpromCapability.class;
            }
            case URL: {
                return UrlCapability.class;
            }
            case CONTENTS: {
                return CardContentsProvider.class;
            }
            case PORTS: {
                return PortProvider.class;
            }
            case CUSTOMIZER: {
                return CardCustomizerProvider.class;
            }
            case INTERCEPTOR: {
                return AntTargetInterceptor.class;
            }
            case DELETE: {
                return DeleteCapability.class;
            }
        }
        throw new AssertionError((Object)("" + (Object)((Object)this)));
    }
}

