/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ImportCDCProjectPanel
extends JPanel
implements DocumentListener {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    static final String PROJECT_LOCATION = "ImportProjectLocation";
    private static String prjType;
    private static String location;
    private JButton bBrowse;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel2;
    private JTextField tLocation;

    private ImportCDCProjectPanel(String type) {
        prjType = type;
        this.initComponents();
        this.initAccessibility();
    }

    public synchronized void addListener(DocumentListener listener) {
        this.tLocation.getDocument().addDocumentListener(listener);
    }

    public synchronized void removeListener(DocumentListener listener) {
        this.tLocation.getDocument().removeDocumentListener(listener);
    }

    public synchronized void readData(TemplateWizard object) {
        Object tmp = object.getProperty(PROJECT_LOCATION);
        if (tmp != null) {
            this.tLocation.setText((String)tmp);
        } else {
            FileObject fo = Templates.getExistingSourcesFolder((WizardDescriptor)object);
            File f = fo == null ? null : FileUtil.toFile((FileObject)fo);
            this.tLocation.setText(f == null ? "" : f.getAbsolutePath());
        }
    }

    public synchronized void storeData(TemplateWizard object) {
        String location = this.tLocation.getText();
        object.putProperty(PROJECT_LOCATION, (Object)location);
        String name = new File(location).getName();
        object.putProperty("ProjectName", (Object)("Imported Project" + (name != null ? " - " + name + '1' : "1")));
        String detectedConfiguration = null;
        String detectedProfile = null;
        HashMap map = new HashMap();
        detectedConfiguration = (String)map.get("MicroEdition-Configuration");
        detectedProfile = (String)map.get("MicroEdition-Profile");
        object.putProperty("RequiredConfiguration", (Object)detectedConfiguration);
        object.putProperty("RequiredProfile", (Object)detectedProfile);
    }

    public String getLocationText() {
        return this.tLocation.getText();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.tLocation = new JTextField();
        this.bBrowse = new JButton();
        this.jPanel2 = new JPanel();
        this.setName(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"TITLE_Project", (Object)(prjType.equals("org.netbeans.modules.j2me.cdc.nbproject") ? "CDC Pack 5.5" : "CDC Toolkit")));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"LBL_Import_Info", (Object)(prjType.equals("org.netbeans.modules.j2me.cdc.nbproject") ? "CDC Pack 5.5" : "CDC Toolkit")));
        this.jLabel1.setVerticalAlignment(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"ASCD_Import_Info", (Object)(prjType.equals("org.netbeans.modules.j2me.cdc.nbproject") ? "CDC Pack 5.5" : "CDC Toolkit")));
        this.jLabel2.setLabelFor(this.tLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"LBL_Project_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.add((Component)this.tLocation, gridBagConstraints);
        this.tLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"ACSD_Project_Location", (Object)(prjType.equals("org.netbeans.modules.j2me.cdc.nbproject") ? "CDC Pack 5.5" : "CDC Toolkit")));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowse, (String)NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"LBL_Project_Browse"));
        this.bBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportCDCProjectPanel.this.bBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bBrowse, gridBagConstraints);
        this.bBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"ACSD_Project_Browse1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"ACSN_Project", (Object)(prjType.equals("org.netbeans.modules.j2me.cdc.nbproject") ? "CDC Pack 5.5" : "CDC Toolkit")));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"ACSD_Project", (Object)(prjType.equals("org.netbeans.modules.j2me.cdc.nbproject") ? "CDC Pack 5.5" : "CDC Toolkit")));
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void bBrowseActionPerformed(ActionEvent evt) {
        String folder;
        if (location == null) {
            location = this.tLocation.getText();
        }
        if (location == null || "".equals(location)) {
            location = System.getProperty("user.home", "");
        } else {
            File f = new File(location);
            if (!f.exists() || !f.isDirectory()) {
                location = System.getProperty("user.home", "");
            }
        }
        File origLoc = ProjectChooser.getProjectsFolder();
        ProjectChooser.setProjectsFolder((File)new File(location));
        JFileChooser ch = ImportCDCProjectPanel.createProjectChooser();
        if (0 == ch.showOpenDialog(WindowManager.getDefault().getMainWindow()) && (folder = ch.getSelectedFile().getAbsolutePath()) != null) {
            this.tLocation.setText(folder);
            location = new File(folder).getParent();
        }
        ProjectChooser.setProjectsFolder((File)origLoc);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private static boolean isOldProject(FileObject fo, String type) {
        if (fo == null || !fo.isValid()) {
            return false;
        }
        FileObject xml = fo.getFileObject("nbproject/project.xml");
        FileObject prop = fo.getFileObject("nbproject/project.properties");
        if (xml != null && prop != null) {
            File file = FileUtil.toFile((FileObject)xml);
            try {
                Document doc = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, null, null);
                NodeList nl = doc.getElementsByTagNameNS("http://www.netbeans.org/ns/project/1", "type");
                return nl.item(0).getTextContent().equals(type);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return false;
    }

    public static JFileChooser createProjectChooser() {
        ProjectManager.getDefault().clearNonProjectCache();
        ProjectFileChooser chooser = new ProjectFileChooser();
        chooser.setFileSelectionMode(1);
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            chooser.putClientProperty("GTKFileChooser.showDirectoryIcons", Boolean.TRUE);
        }
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(ProjectDirFilter.INSTANCE);
        File currDir = ProjectChooser.getProjectsFolder();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, (File)currDir);
        chooser.setFileView(new ProjectFileView(chooser.getFileSystemView()));
        return chooser;
    }

    private static class ProjectDirFilter
    extends FileFilter {
        private static final FileFilter INSTANCE = new ProjectDirFilter();

        private ProjectDirFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "";
        }
    }

    private static class ProjectFileChooser
    extends JFileChooser {
        private ProjectFileChooser() {
        }

        @Override
        public void approveSelection() {
            File dir = FileUtil.normalizeFile((File)this.getSelectedFile());
            if (dir != null && ImportCDCProjectPanel.isOldProject(FileUtil.toFileObject((File)dir), prjType)) {
                super.approveSelection();
            } else {
                this.setCurrentDirectory(dir);
            }
        }
    }

    private static class MergedIcon
    implements Icon {
        private Icon icon1;
        private Icon icon2;
        private int xMerge;
        private int yMerge;

        MergedIcon(Icon icon1, Icon icon2, int xMerge, int yMerge) {
            this.icon1 = icon1;
            this.icon2 = icon2;
            if (xMerge == -1) {
                xMerge = icon1.getIconWidth() - icon2.getIconWidth();
            }
            if (yMerge == -1) {
                yMerge = icon1.getIconHeight() - icon2.getIconHeight();
            }
            this.xMerge = xMerge;
            this.yMerge = yMerge;
        }

        @Override
        public int getIconHeight() {
            return Math.max(this.icon1.getIconHeight(), this.yMerge + this.icon2.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return Math.max(this.icon1.getIconWidth(), this.yMerge + this.icon2.getIconWidth());
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon1.paintIcon(c, g, x, y);
            this.icon2.paintIcon(c, g, x + this.xMerge, y + this.yMerge);
        }
    }

    private static class ProjectFileView
    extends FileView {
        private final FileSystemView fsv;
        private static final Icon BADGE = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2me/cdc/project/resources/projectBadge.gif", (boolean)false);
        private static final Icon EMPTY = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/project/ui/resources/empty.gif", (boolean)false);
        private Icon lastOriginal;
        private Icon lastMerged;

        public ProjectFileView(FileSystemView fs) {
            this.fsv = fs;
        }

        @Override
        public Icon getIcon(File _f) {
            FileObject fo;
            if (!_f.exists()) {
                return null;
            }
            File f = FileUtil.normalizeFile((File)_f);
            Icon or = this.fsv.getSystemIcon(f);
            if (or == null) {
                or = EMPTY;
            }
            if ((fo = FileUtil.toFileObject((File)f)) != null && ImportCDCProjectPanel.isOldProject(fo, prjType)) {
                if (or.equals(this.lastOriginal)) {
                    return this.lastMerged;
                }
                this.lastOriginal = or;
                this.lastMerged = new MergedIcon(or, BADGE, -1, -1);
                return this.lastMerged;
            }
            return or;
        }
    }

    static class WizardPanel
    implements WizardDescriptor.FinishablePanel,
    DocumentListener {
        ImportCDCProjectPanel component;
        TemplateWizard wizard;
        Collection<ChangeListener> listeners = new ArrayList<ChangeListener>();
        boolean valid = false;
        final String prjType;

        public WizardPanel(String type) {
            this.prjType = type;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new ImportCDCProjectPanel(this.prjType);
                this.component.addListener(this);
                this.checkValid();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(ImportCDCProjectPanel.class);
        }

        public boolean isFinishPanel() {
            return false;
        }

        public void showError(String message) {
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
            }
        }

        public boolean isValid() {
            boolean valid;
            File f = FileUtil.normalizeFile((File)new File(this.component.getLocationText()).getAbsoluteFile());
            boolean bl = valid = this.component.getLocationText().length() > 0 && f != null && f.exists() && f.isDirectory() && ImportCDCProjectPanel.isOldProject(FileUtil.toFileObject((File)f), prjType);
            if (!valid) {
                this.showError(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"ERR_Project_InvalidLocation"));
                return false;
            }
            this.showError(null);
            return true;
        }

        public void readSettings(Object obj) {
            this.wizard = (TemplateWizard)obj;
            ((ImportCDCProjectPanel)this.getComponent()).readData(this.wizard);
            Component component = this.getComponent();
            Object substitute = ((JComponent)component).getClientProperty("NewProjectWizard_Title");
            if (substitute != null) {
                this.wizard.putProperty("NewProjectWizard_Title", substitute);
            }
        }

        public void storeSettings(Object obj) {
            this.wizard = (TemplateWizard)obj;
            ((ImportCDCProjectPanel)this.getComponent()).storeData(this.wizard);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] ll;
            WizardPanel wizardPanel = this;
            synchronized (wizardPanel) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent ev = new ChangeEvent(this);
            for (int i = 0; i < ll.length; ++i) {
                ll[i].stateChanged(ev);
            }
        }

        void checkValid() {
            if (this.isValid() != this.valid) {
                this.valid ^= true;
                this.fireStateChange();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.checkValid();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkValid();
        }
    }
}

