/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ui;

import java.io.File;
import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class CDCFoldersListSettings {
    private static Preferences prefs = NbPreferences.forModule(CDCFoldersListSettings.class);
    private static final long serialVersionUID = 2386225041150479082L;
    private static final String NEW_PROJECT_COUNT = "newProjectCount";
    private static final String NEW_APP_COUNT = "newApplicationCount";
    private static final String NEW_LIB_COUNT = "newLibraryCount";
    private static final String LAST_USED_CP_FOLDER = "lastUsedClassPathFolder";
    private static final String LAST_USED_ARTIFACT_FOLDER = "lastUsedArtifactFolder";

    public static String displayName() {
        return NbBundle.getMessage(CDCFoldersListSettings.class, (String)"TXT_CDCProjectFolderList");
    }

    public static int getNewProjectCount() {
        return prefs.getInt(NEW_PROJECT_COUNT, 0);
    }

    public static void setNewProjectCount(int count) {
        prefs.putInt(NEW_PROJECT_COUNT, count);
    }

    public static int getNewApplicationCount() {
        return prefs.getInt(NEW_APP_COUNT, 0);
    }

    public static void setNewApplicationCount(int count) {
        prefs.putInt(NEW_APP_COUNT, count);
    }

    public static int getNewLibraryCount() {
        return prefs.getInt(NEW_LIB_COUNT, 0);
    }

    public static void setNewLibraryCount(int count) {
        prefs.putInt(NEW_LIB_COUNT, count);
    }

    public static File getLastUsedClassPathFolder() {
        String lucpr = prefs.get(LAST_USED_CP_FOLDER, System.getProperty("user.home"));
        return new File(lucpr);
    }

    public static void setLastUsedClassPathFolder(File folder) {
        assert (folder != null) : "ClassPath root can not be null";
        String path = folder.getAbsolutePath();
        prefs.put(LAST_USED_CP_FOLDER, path);
    }

    public static File getLastUsedArtifactFolder() {
        String folder = prefs.get(LAST_USED_ARTIFACT_FOLDER, System.getProperty("user.home"));
        return new File(folder);
    }

    public static void setLastUsedArtifactFolder(File folder) {
        assert (folder != null) : "Folder can not be null";
        String path = folder.getAbsolutePath();
        prefs.put(LAST_USED_ARTIFACT_FOLDER, path);
    }
}

