/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.modules.j2ee;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.modules.j2ee.nodes.GlassFishV2ServerNode;
import org.netbeans.jellytools.modules.j2ee.nodes.GlassFishV3ServerNode;
import org.netbeans.jellytools.modules.j2ee.nodes.J2eeServerNode;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.junit.NbModuleSuite;

public class J2eeTestCase
extends JellyTestCase {
    private static final String PID_FILE_PREFIX = "J2EE_TEST_CASE_PID_FILE";
    private static final String GLASSFISH_PATH = "com.sun.aas.installRoot";
    private static final String GLASSFISH_V3_PATH = "org.glassfish.v3ee6.installRoot";
    private static final String TOMCAT_PATH = "org.netbeans.modules.tomcat.autoregister.catalinaHome";
    private static final String JBOSS_PATH = "org.netbeans.modules.j2ee.jboss4.installRoot";
    private static final String GLASSFISH_HOME = "glassfish.home";
    private static final String TOMCAT_HOME = "tomcat.home";
    private static final String JBOSS_HOME = "jboss.home";
    private static final Logger LOG = Logger.getLogger(J2eeTestCase.class.getName());
    private static boolean serversLogged = false;

    public J2eeTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createPid();
    }

    private void createPid() throws IOException {
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        pid = pid.substring(0, pid.indexOf(64));
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirPath);
        for (String file : tmpDir.list()) {
            if (!file.startsWith(PID_FILE_PREFIX) || new File(tmpDir, file).delete()) continue;
            LOG.warning("File '" + tmpDirPath + File.pathSeparator + file + "' not successfully deleted!");
        }
        if (!new File(tmpDir, PID_FILE_PREFIX + pid).createNewFile()) {
            LOG.warning("File '" + tmpDirPath + File.pathSeparator + PID_FILE_PREFIX + pid + "' not successfully created!");
        }
    }

    private static void registerGlassfish() {
        String glassfishPath = J2eeTestCase.getServerHome(Server.GLASSFISH);
        if (J2eeTestCase.isValidPath(glassfishPath) && J2eeTestCase.isValidPath(glassfishPath + "/domains/domain1")) {
            LOG.info("Setting server path " + glassfishPath);
            System.setProperty(GLASSFISH_PATH, glassfishPath);
        }
    }

    private static void registerGlassfishV3() {
        String glassfishPath = J2eeTestCase.getServerHome(Server.GLASSFISH_V3);
        if (J2eeTestCase.isValidPath(glassfishPath) && J2eeTestCase.isValidPath(glassfishPath + "/glassfish/domains/domain1")) {
            LOG.info("Setting server path " + glassfishPath);
            System.setProperty(GLASSFISH_V3_PATH, glassfishPath);
        }
    }

    private static void registerTomcat() {
        String tomcatPath = J2eeTestCase.getServerHome(Server.TOMCAT);
        if (J2eeTestCase.isValidPath(tomcatPath)) {
            LOG.info("Setting server path " + tomcatPath);
            System.setProperty(TOMCAT_PATH, tomcatPath);
            System.setProperty("org.netbeans.modules.tomcat.autoregister.token", "1");
        }
    }

    private static void registerJBoss() {
        String jbossPath = J2eeTestCase.getServerHome(Server.JBOSS);
        if (J2eeTestCase.isValidPath(jbossPath)) {
            LOG.info("Setting server path " + jbossPath);
            System.setProperty(JBOSS_PATH, jbossPath);
        }
    }

    private static String getServerHome(Server server) {
        switch (server) {
            case JBOSS: {
                return System.getProperty(JBOSS_HOME);
            }
            case GLASSFISH: 
            case GLASSFISH_V3: {
                String glassfishPath = System.getProperty(GLASSFISH_HOME);
                if (glassfishPath == null) {
                    glassfishPath = System.getProperty("j2ee.appserver.path");
                }
                return glassfishPath;
            }
            case TOMCAT: {
                return System.getProperty(TOMCAT_HOME);
            }
        }
        return null;
    }

    private static boolean isValidPath(String path) {
        if (path == null) {
            return false;
        }
        LOG.info("Validating path: " + path);
        File f = new File(path);
        if (f.isDirectory()) {
            LOG.info(path + " - is valid directory");
            return true;
        }
        if (!f.exists()) {
            LOG.info(path + " - does not exists!");
        } else {
            LOG.info(path + " - exists, but it is not a directory!");
        }
        return false;
    }

    protected static Test createAllModulesServerSuite(Server server, Class<? extends TestCase> clazz, String ... testNames) {
        NbModuleSuite.Configuration result = NbModuleSuite.createConfiguration(clazz);
        result = J2eeTestCase.addServerTests(server, result, testNames).enableModules(".*").clusters(".*");
        return NbModuleSuite.create((NbModuleSuite.Configuration)result);
    }

    protected static NbModuleSuite.Configuration addServerTests(NbModuleSuite.Configuration conf, String ... testNames) {
        return J2eeTestCase.addServerTests(Server.ANY, conf, testNames);
    }

    protected static NbModuleSuite.Configuration addServerTests(Server server, NbModuleSuite.Configuration conf, String ... testNames) {
        return J2eeTestCase.addServerTests(server, conf, null, testNames);
    }

    protected static NbModuleSuite.Configuration addServerTests(Server server, NbModuleSuite.Configuration conf, Class<? extends TestCase> clazz, String ... testNames) {
        if (J2eeTestCase.isRegistered(server)) {
            LOG.info("adding server tests");
            return J2eeTestCase.addTest(conf, clazz, testNames);
        }
        if (server.equals((Object)Server.GLASSFISH_V3) || server.equals((Object)Server.ANY)) {
            J2eeTestCase.registerGlassfishV3();
            if (J2eeTestCase.isRegistered(Server.GLASSFISH_V3)) {
                return J2eeTestCase.addTest(conf, clazz, testNames);
            }
        }
        if (server.equals((Object)Server.GLASSFISH) || server.equals((Object)Server.ANY)) {
            J2eeTestCase.registerGlassfish();
            if (J2eeTestCase.isRegistered(Server.GLASSFISH)) {
                return J2eeTestCase.addTest(conf, clazz, testNames);
            }
        }
        if (server.equals((Object)Server.TOMCAT) || server.equals((Object)Server.ANY)) {
            J2eeTestCase.registerTomcat();
            if (J2eeTestCase.isRegistered(Server.TOMCAT)) {
                return J2eeTestCase.addTest(conf, clazz, testNames);
            }
        }
        if (server.equals((Object)Server.JBOSS) || server.equals((Object)Server.ANY)) {
            J2eeTestCase.registerJBoss();
            if (J2eeTestCase.isRegistered(Server.JBOSS)) {
                return J2eeTestCase.addTest(conf, clazz, testNames);
            }
        }
        LOG.info("no server to add tests");
        if (!serversLogged) {
            serversLogged = true;
            J2eeTestCase.logServer(JBOSS_HOME, J2eeTestCase.getServerHome(Server.JBOSS));
            J2eeTestCase.logServer(TOMCAT_HOME, J2eeTestCase.getServerHome(Server.TOMCAT));
            J2eeTestCase.logServer(GLASSFISH_HOME, J2eeTestCase.getServerHome(Server.GLASSFISH));
            J2eeTestCase.logServer(GLASSFISH_HOME, J2eeTestCase.getServerHome(Server.GLASSFISH_V3));
        }
        try {
            return conf.addTest(new String[]{"testEmpty"});
        }
        catch (IllegalStateException exc) {
            return conf.addTest(J2eeTestCase.class, new String[]{"testEmpty"});
        }
    }

    private static void logServer(String propName, String value) {
        if (value == null) {
            LOG.info(propName + " is not set");
        } else {
            LOG.info(propName + " is " + value);
        }
    }

    protected static boolean isRegistered(Server server) {
        boolean result;
        switch (server) {
            case GLASSFISH_V3: {
                result = System.getProperty(GLASSFISH_V3_PATH) != null;
                break;
            }
            case GLASSFISH: {
                result = System.getProperty(GLASSFISH_PATH) != null;
                break;
            }
            case JBOSS: {
                result = System.getProperty(JBOSS_PATH) != null;
                break;
            }
            case TOMCAT: {
                result = System.getProperty(TOMCAT_PATH) != null;
                break;
            }
            case ANY: {
                for (Server serv : Server.values()) {
                    if (serv.equals((Object)Server.ANY) || !J2eeTestCase.isRegistered(serv)) continue;
                    return true;
                }
                return false;
            }
            default: {
                throw new IllegalArgumentException("Unsupported server");
            }
        }
        return result;
    }

    protected J2eeServerNode getServerNode(Server server) {
        if (!J2eeTestCase.isRegistered(server)) {
            throw new IllegalArgumentException("Server is not registred in IDE");
        }
        switch (server) {
            case GLASSFISH_V3: {
                return GlassFishV3ServerNode.invoke();
            }
            case GLASSFISH: {
                return GlassFishV2ServerNode.invoke();
            }
            case JBOSS: {
                return J2eeServerNode.invoke("JBoss");
            }
            case TOMCAT: {
                return J2eeServerNode.invoke("Tomcat");
            }
            case ANY: {
                for (Server serv : Server.values()) {
                    if (serv.equals((Object)Server.ANY) || !J2eeTestCase.isRegistered(serv)) continue;
                    return this.getServerNode(serv);
                }
                throw new IllegalArgumentException("No server is registred in IDE");
            }
        }
        throw new IllegalArgumentException("Unsupported server");
    }

    public void testEmpty() {
    }

    private static NbModuleSuite.Configuration addTest(NbModuleSuite.Configuration conf, Class<? extends TestCase> clazz, String ... testNames) {
        if (testNames == null || testNames.length == 0) {
            return conf;
        }
        if (clazz == null) {
            return conf.addTest(testNames);
        }
        return conf.addTest(clazz, testNames);
    }

    protected void resolveServer(String projectName) {
        this.waitScanFinished();
        String openProjectTitle = Bundle.getString((String)"org.netbeans.modules.j2ee.common.ui.Bundle", (String)"MSG_Broken_Server_Title");
        if (JDialogOperator.findJDialog((String)openProjectTitle, (boolean)true, (boolean)true) != null) {
            new NbDialogOperator(openProjectTitle).close();
            LOG.info("Resolving server");
            ProjectsTabOperator.invoke().getProjectRootNode(projectName).properties();
            String projectPropertiesTitle = Bundle.getStringTrimmed((String)"org.netbeans.modules.web.project.ui.customizer.Bundle", (String)"LBL_Customizer_Title");
            NbDialogOperator propertiesDialogOper = new NbDialogOperator(projectPropertiesTitle);
            new Node(new JTreeOperator((ContainerOperator)propertiesDialogOper), "Run").select();
            new JComboBoxOperator((ContainerOperator)propertiesDialogOper).setSelectedIndex(0);
            propertiesDialogOper.ok();
            this.waitScanFinished();
        }
        String editPropertiesTitle = Bundle.getStringTrimmed((String)"org.netbeans.modules.web.project.Bundle", (String)"TXT_BuildImplRegenerateTitle");
        int count = 0;
        while (JDialogOperator.findJDialog((String)editPropertiesTitle, (boolean)true, (boolean)true) != null && count < 10) {
            ++count;
            NbDialogOperator dialog = new NbDialogOperator(editPropertiesTitle);
            String regenerateButtonTitle = Bundle.getStringTrimmed((String)"org.netbeans.modules.web.project.Bundle", (String)"CTL_Regenerate");
            JButtonOperator butt = new JButtonOperator((ContainerOperator)dialog, regenerateButtonTitle);
            butt.push();
            LOG.info("Closing buildscript regeneration");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException exc) {
                LOG.log(Level.INFO, "interrupt exception", exc);
            }
            if (!dialog.isVisible()) continue;
            dialog.close();
        }
    }

    public static enum Server {
        TOMCAT,
        GLASSFISH,
        GLASSFISH_V3,
        JBOSS,
        ANY;

    }
}

