/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.ControlModuleCookie;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.ModuleCookieSupport;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.OpenModuleUrlAction;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.OpenModuleUrlCookie;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.StartModuleAction;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.StopModuleAction;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.UndeployModuleAction;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.UndeployModuleCookie;
import org.openide.awt.HtmlBrowser;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class WLModuleNode
extends AbstractNode {
    private static final Logger LOGGER = Logger.getLogger(WLModuleNode.class.getName());
    private final ModuleType moduleType;
    private final boolean stopped;
    private final String name;
    private final String url;
    private final TargetModuleID module;

    public WLModuleNode(TargetModuleID targetModuleID, Lookup lookup, ModuleType moduleType, boolean bl) {
        super(Children.LEAF);
        this.module = targetModuleID;
        this.moduleType = moduleType;
        this.stopped = bl;
        this.url = targetModuleID.getWebURL();
        this.name = targetModuleID.getModuleID();
        if (bl) {
            this.setDisplayName(this.name + " " + "[" + NbBundle.getMessage(WLModuleNode.class, (String)"LBL_Stopped") + "]");
        } else {
            this.setDisplayName(this.name);
        }
        if (this.url != null) {
            this.getCookieSet().add((Node.Cookie)new OpenModuleUrlCookieImpl(this.url));
        }
        this.getCookieSet().add((Node.Cookie)new ControlModuleCookieImpl(targetModuleID, lookup, !bl));
        this.getCookieSet().add((Node.Cookie)new UndeployModuleCookieImpl(targetModuleID, lookup));
    }

    public Action[] getActions(boolean bl) {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>(7);
        arrayList.add(SystemAction.get(StartModuleAction.class));
        arrayList.add(SystemAction.get(StopModuleAction.class));
        arrayList.add(null);
        arrayList.add(SystemAction.get(OpenModuleUrlAction.class));
        arrayList.add(null);
        arrayList.add(SystemAction.get(UndeployModuleAction.class));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public Image getIcon(int n) {
        if (ModuleType.EAR.equals(this.moduleType)) {
            return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.EAR_ARCHIVE);
        }
        if (ModuleType.EJB.equals(this.moduleType)) {
            return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.EJB_ARCHIVE);
        }
        if (ModuleType.WAR.equals(this.moduleType)) {
            return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.WAR_ARCHIVE);
        }
        return super.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    private static class ControlModuleCookieImpl
    implements ControlModuleCookie {
        private final ModuleCookieSupport support;
        private final boolean running;

        public ControlModuleCookieImpl(TargetModuleID targetModuleID, Lookup lookup, boolean bl) {
            this.support = new ModuleCookieSupport(targetModuleID, lookup);
            this.running = bl;
        }

        @Override
        public void start() {
            this.support.performAction(new ModuleCookieSupport.Action(){

                @Override
                public ProgressObject execute(DeploymentManager deploymentManager, TargetModuleID targetModuleID) {
                    return deploymentManager.start(new TargetModuleID[]{targetModuleID});
                }
            });
        }

        @Override
        public void stop() {
            this.support.performAction(new ModuleCookieSupport.Action(){

                @Override
                public ProgressObject execute(DeploymentManager deploymentManager, TargetModuleID targetModuleID) {
                    return deploymentManager.stop(new TargetModuleID[]{targetModuleID});
                }
            });
        }

        @Override
        public boolean isRunning() {
            return this.running;
        }
    }

    private static class UndeployModuleCookieImpl
    implements UndeployModuleCookie {
        private final ModuleCookieSupport support;

        public UndeployModuleCookieImpl(TargetModuleID targetModuleID, Lookup lookup) {
            this.support = new ModuleCookieSupport(targetModuleID, lookup);
        }

        @Override
        public void undeploy() {
            this.support.performAction(new ModuleCookieSupport.Action(){

                @Override
                public ProgressObject execute(DeploymentManager deploymentManager, TargetModuleID targetModuleID) {
                    return deploymentManager.undeploy(new TargetModuleID[]{targetModuleID});
                }
            });
        }
    }

    private static class OpenModuleUrlCookieImpl
    implements OpenModuleUrlCookie {
        private final String url;

        public OpenModuleUrlCookieImpl(String string) {
            this.url = string;
        }

        @Override
        public void openUrl() {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(this.url));
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.log(Level.INFO, null, malformedURLException);
            }
        }
    }
}

