/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.j2ee.common.DatasourceHelper;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentStatus;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLProgressObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class WLDriverDeployer
implements JDBCDriverDeployer {
    private static final Logger LOGGER = Logger.getLogger(WLDriverDeployer.class.getName());
    private final WLDeploymentManager manager;
    private static final FileFilter CLASSPATH_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".jar");
        }
    };

    public WLDriverDeployer(WLDeploymentManager wLDeploymentManager) {
        this.manager = wLDeploymentManager;
    }

    public boolean supportsDeployJDBCDrivers(Target target) {
        return true;
    }

    public ProgressObject deployJDBCDrivers(Target target, final Set<Datasource> set) {
        final WLProgressObject wLProgressObject = new WLProgressObject(new TargetModuleID[0]);
        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(WLDriverDeployer.class, (String)"MSG_CheckingMissingDrivers")));
        WLDeploymentFactory.getInstance().getExecutorService().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = WLDriverDeployer.this.jdbcDriversToDeploy(set);
                if (!list.isEmpty()) {
                    File file = WLPluginProperties.getDomainLibDirectory(WLDriverDeployer.this.manager);
                    if (file != null) {
                        for (FileObject fileObject : list) {
                            File file2 = new File(file, fileObject.getNameExt());
                            try {
                                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject.getInputStream());
                                try {
                                    wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(WLDriverDeployer.class, (String)"MSG_DeployingJDBCDrivers", (Object)file2.getPath())));
                                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                                    try {
                                        FileUtil.copy((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
                                    }
                                    finally {
                                        bufferedOutputStream.close();
                                    }
                                }
                                finally {
                                    bufferedInputStream.close();
                                }
                            }
                            catch (IOException iOException) {
                                LOGGER.log(Level.INFO, null, iOException);
                                wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(WLDriverDeployer.class, (String)"MSG_DeployingJDBCDriversFailed", (Object)file2.getPath(), (Object)file.getPath())));
                                return;
                            }
                        }
                    }
                    LOGGER.log(Level.FINE, "Restart flag configured");
                    WLDriverDeployer.this.manager.setRestartNeeded(true);
                }
                wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, NbBundle.getMessage(WLDriverDeployer.class, (String)"MSG_JDBCDriversDeployed")));
            }
        });
        return wLProgressObject;
    }

    private List<FileObject> jdbcDriversToDeploy(Set<Datasource> set) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        Collection<File> collection = this.getJDBCDriverClasspath();
        for (Datasource datasource : set) {
            String string = datasource.getDriverClassName();
            boolean bl = false;
            try {
                bl = Util.containsClass(collection, (String)string);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
            if (bl) continue;
            for (DatabaseConnection databaseConnection : DatasourceHelper.findDatabaseConnections((Datasource)datasource)) {
                JDBCDriver[] jDBCDriverArray;
                JDBCDriver jDBCDriver = databaseConnection.getJDBCDriver();
                if (jDBCDriver != null) {
                    jDBCDriverArray = new JDBCDriver[]{jDBCDriver};
                } else {
                    JDBCDriver[] jDBCDriverArray2 = databaseConnection.getDriverClass();
                    jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers((String)jDBCDriverArray2);
                }
                for (JDBCDriver jDBCDriver2 : jDBCDriverArray) {
                    for (URL uRL : jDBCDriver2.getURLs()) {
                        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                        if (fileObject == null) continue;
                        arrayList.add(fileObject);
                    }
                }
            }
        }
        return arrayList;
    }

    private Collection<File> getJDBCDriverClasspath() {
        File[] fileArray;
        Object object;
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = WLPluginProperties.getDomainLibDirectory(this.manager);
        if (file != null && (object = file.listFiles(CLASSPATH_FILTER)) != null) {
            arrayList.addAll(Arrays.asList(object));
        }
        if ((object = WLPluginProperties.getServerLibDirectory(this.manager)) != null && (fileArray = ((File)object).listFiles(CLASSPATH_FILTER)) != null) {
            arrayList.addAll(Arrays.asList(fileArray));
        }
        return arrayList;
    }
}

