/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.visitor;

import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.visitor.DeepAXITreeVisitor;

public class PrintAXITreeVisitor
extends DeepAXITreeVisitor {
    private int depth = 0;
    private static boolean PRINT_TO_CONSOLE = false;

    @Override
    protected void visitChildren(AXIComponent component) {
        if (PRINT_TO_CONSOLE) {
            this.printModel(component);
        }
        ++this.depth;
        super.visitChildren(component);
        --this.depth;
    }

    private void printModel(AXIComponent component) {
        AbstractElement element;
        StringBuffer buffer = new StringBuffer();
        if (component instanceof Compositor) {
            Compositor compositor = (Compositor)component;
            buffer.append(this.getTab() == null ? compositor : this.getTab() + compositor);
            buffer.append("<min=" + compositor.getMinOccurs() + ":max=" + compositor.getMaxOccurs() + ">");
        }
        if (component instanceof Element) {
            element = (Element)component;
            buffer.append(this.getTab() == null ? element.getName() : this.getTab() + element.getName());
            if (element.getAttributes().size() != 0) {
                buffer.append("<" + this.getAttributes((Element)element) + ">");
            }
            buffer.append("<min=" + element.getMinOccurs() + ":max=" + element.getMaxOccurs() + ">");
        }
        if (component instanceof AnyElement) {
            element = (AnyElement)component;
            buffer.append(this.getTab() == null ? element : this.getTab() + element);
        }
        System.out.println(buffer.toString());
    }

    private String getAttributes(Element element) {
        StringBuffer attrs = new StringBuffer();
        for (AbstractAttribute attr : element.getAttributes()) {
            attrs.append(attr + ":");
        }
        if (attrs.length() > 0) {
            return attrs.toString().substring(0, attrs.length() - 1);
        }
        return attrs.toString();
    }

    private String getTab() {
        String tabStr = "++++";
        if (this.depth == 0) {
            return null;
        }
        StringBuffer tab = new StringBuffer();
        for (int i = 0; i < this.depth; ++i) {
            tab.append(tabStr);
        }
        return tab.toString();
    }
}

