/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.settings;

import java.beans.PropertyEditorManager;
import java.io.File;
import java.util.ResourceBundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class MakeSettings
extends SharedClassObject {
    static final long serialVersionUID = 1276277545941336641L;
    public static final String PROP_DEFAULT_BUILD_DIR = "defaultBuildDirectory";
    public static final String PROP_EXECUTOR = "executor";
    public static final String PROP_REUSE_OUTPUT = "reuseOutput";
    public static final String PROP_SAVE_ALL = "saveAll";
    private static ResourceBundle bundle;

    protected void initialize() {
        super.initialize();
        this.registerPropertyEditors();
        this.setReuseOutput(false);
        this.setSaveAll(true);
    }

    public String displayName() {
        return MakeSettings.getString("OPTION_MAKE_SETTINGS_NAME");
    }

    public static MakeSettings getDefault() {
        return (MakeSettings)MakeSettings.findObject(MakeSettings.class, (boolean)true);
    }

    static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(MakeSettings.class);
        }
        return bundle.getString(s);
    }

    private void registerPropertyEditors() {
        String[] searchPath = PropertyEditorManager.getEditorSearchPath();
        String[] newSP = new String[searchPath.length + 1];
        System.arraycopy(searchPath, 0, newSP, 0, searchPath.length);
        newSP[searchPath.length] = "org.netbeans.modules.cnd.builds";
        PropertyEditorManager.setEditorSearchPath(newSP);
    }

    public String getDefaultBuildDirectory() {
        String dir = (String)this.getProperty(PROP_DEFAULT_BUILD_DIR);
        if (dir == null) {
            return ".";
        }
        return dir;
    }

    public void setDefaultBuildDirectory(String dir) {
        if (!dir.startsWith(File.separator)) {
            String odir = this.getDefaultBuildDirectory();
            if (!odir.equals(dir)) {
                this.putProperty(PROP_DEFAULT_BUILD_DIR, dir, true);
            }
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeSettings.getString("MSG_RelBuildPath")));
        }
    }

    public String getDefaultMakeCommand() {
        return "make";
    }

    public boolean getReuseOutput() {
        return (Boolean)this.getProperty(PROP_REUSE_OUTPUT);
    }

    public void setReuseOutput(boolean b) {
        this.putProperty(PROP_REUSE_OUTPUT, b ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public boolean getSaveAll() {
        return (Boolean)this.getProperty(PROP_SAVE_ALL);
    }

    public void setSaveAll(boolean sa) {
        this.putProperty(PROP_SAVE_ALL, sa ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Welcome_opt_building_make");
    }
}

