/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.cnd.editor.filecreation.PhysicalView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public abstract class CndPanelGUI
extends JPanel
implements DocumentListener {
    protected Project project;
    protected SourceGroup[] folders;
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    protected static final String NEW_FILE_PREFIX = CndPanelGUI.getMessage("LBL_NewCndFileChooserPanelGUI_NewFilePrefix");
    protected final ListCellRenderer CELL_RENDERER = new GroupCellRenderer();
    protected final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public CndPanelGUI(Project project, SourceGroup[] folders) {
        this.project = project;
        this.folders = folders;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public abstract SourceGroup getTargetGroup();

    public abstract String getTargetFolder();

    public abstract String getTargetName();

    protected abstract void updateCreatedFile();

    public abstract void initValues(FileObject var1, FileObject var2, String var3);

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateCreatedFile();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateCreatedFile();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateCreatedFile();
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    protected static SourceGroup getPreselectedGroup(SourceGroup[] groups, FileObject folder) {
        for (int i = 0; folder != null && i < groups.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)groups[i].getRootFolder(), (FileObject)folder) && !groups[i].getRootFolder().equals(folder)) continue;
            return groups[i];
        }
        return groups[0];
    }

    protected static String getRelativeNativeName(FileObject root, FileObject folder) {
        if (root == null) {
            throw new NullPointerException("null root passed to getRelativeNativeName");
        }
        String path = folder == null ? "" : FileUtil.getRelativePath((FileObject)root, (FileObject)folder);
        return path == null ? "" : path.replace('/', File.separatorChar);
    }

    protected static String generateUniqueSuffix(FileObject folder, String prefix, String ... extensions) {
        int i = 0;
        while (true) {
            String suffix = i == 0 ? "" : String.valueOf(i);
            String filename = prefix + suffix;
            boolean unique = true;
            for (String ext : extensions) {
                if (folder.getFileObject(filename, ext) == null) continue;
                unique = false;
                break;
            }
            if (unique) {
                return suffix;
            }
            ++i;
        }
    }

    protected static String getMessage(String name) {
        return NbBundle.getMessage(CndPanelGUI.class, (String)name);
    }

    protected class GroupCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public GroupCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof SourceGroup) {
                String groupDisplayName;
                SourceGroup group = (SourceGroup)value;
                String projectDisplayName = ProjectUtils.getInformation((Project)CndPanelGUI.this.project).getDisplayName();
                if (projectDisplayName.equals(groupDisplayName = group.getDisplayName())) {
                    this.setText(groupDisplayName);
                } else {
                    this.setText(MessageFormat.format(PhysicalView.GroupNode.GROUP_NAME_PATTERN, groupDisplayName, projectDisplayName, group.getRootFolder().getName()));
                }
                this.setIcon(group.getIcon(false));
            } else {
                this.setText(value == null ? "" : value.toString());
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

