/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.File;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

public class CndVisibilityQuery
implements VisibilityQueryImplementation2 {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private Pattern pattern = null;

    public CndVisibilityQuery(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    public void setPattern(String regex) {
        if (this.pattern != null && regex != null && !this.pattern.pattern().equals(regex)) {
            this.pattern = Pattern.compile(regex);
            this.cs.fireChange();
        } else if (this.pattern == null && regex != null) {
            this.pattern = Pattern.compile(regex);
            this.cs.fireChange();
        }
    }

    public String getRegEx() {
        return this.pattern.pattern();
    }

    public boolean isVisible(FileObject file) {
        return this.isVisible(file.getNameExt());
    }

    public boolean isVisible(File file) {
        return this.isVisible(file.getName());
    }

    public boolean isVisible(String fileName) {
        return this.pattern.matcher(fileName).find();
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }
}

