/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.properties.SvnPropertiesAction;
import org.netbeans.modules.subversion.ui.status.OpenInEditorAction;
import org.netbeans.modules.subversion.ui.update.FileUpdateInfo;
import org.netbeans.modules.subversion.ui.update.ResolveConflictsAction;
import org.netbeans.modules.subversion.ui.update.UpdateResultNode;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.SortedTable;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

class UpdateResultsTable
implements MouseListener,
ListSelectionListener,
AncestorListener,
VersioningListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private UpdateResultNode[] nodes = new UpdateResultNode[0];
    private String[] tableColumns;
    private TableSorter sorter;
    private static final int ACTION_CONFLICTED_FILE = FileUpdateInfo.ACTION_CONFLICTED | FileUpdateInfo.ACTION_TYPE_FILE;
    private final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private static final Comparator NodeComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Node.Property p1 = (Node.Property)o1;
            Node.Property p2 = (Node.Property)o2;
            String sk1 = (String)p1.getValue("sortkey");
            if (sk1 != null) {
                String sk2 = (String)p2.getValue("sortkey");
                return sk1.compareToIgnoreCase(sk2);
            }
            try {
                String s1 = (String)p1.getValue();
                String s2 = (String)p2.getValue();
                return s1.compareToIgnoreCase(s2);
            }
            catch (Exception e) {
                Subversion.LOG.log(Level.SEVERE, null, e);
                return 0;
            }
        }
    };
    private static ActionEvaluator conflictEvaluator = new ActionEvaluator(){

        @Override
        public boolean isAction(FileUpdateInfo info) {
            return (info.getAction() & ACTION_CONFLICTED_FILE) == ACTION_CONFLICTED_FILE;
        }
    };
    private static ActionEvaluator notDeletedEvaluator = new ActionEvaluator(){

        @Override
        public boolean isAction(FileUpdateInfo info) {
            return (info.getAction() & ~FileUpdateInfo.ACTION_DELETED) != 0;
        }
    };

    public UpdateResultsTable() {
        ResourceBundle loc = NbBundle.getBundle(UpdateResultsTable.class);
        this.columnLabels.put("name", new String[]{loc.getString("CTL_UpdateResults_Column_File_Title"), loc.getString("CTL_UpdateResults_Column_File_Desc")});
        this.columnLabels.put("status", new String[]{loc.getString("CTL_UpdateResults_Column_Status_Title"), loc.getString("CTL_UpdateResults_Column_Status_Desc")});
        this.columnLabels.put("path", new String[]{loc.getString("CTL_UpdateResults_Column_Path_Title"), loc.getString("CTL_UpdateResults_Column_Path_Desc")});
        this.tableModel = new NodeTableModel();
        Subversion.getInstance().getStatusCache().addVersioningListener(this);
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new SortedTable(this.sorter);
        int height = new JLabel((String)"FONTSIZE").getPreferredSize().height * 6 / 5;
        this.table.setRowHeight(height);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color borderColor = UIManager.getColor("scrollpane_border");
        if (borderColor == null) {
            borderColor = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new SyncTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UpdateResultsTable.class, (String)"ACSN_UpdateResults"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateResultsTable.class, (String)"ACSD_UpdateResults"));
        this.setColumns(new String[]{"name", "status", "path"});
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = UpdateResultsTable.this.table.getWidth();
                for (int i = 0; i < UpdateResultsTable.this.tableColumns.length; ++i) {
                    if ("path".equals(UpdateResultsTable.this.tableColumns[i])) {
                        UpdateResultsTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 60 / 100);
                        continue;
                    }
                    UpdateResultsTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 20 / 100);
                }
            }
        });
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    public UpdateResultNode[] getDisplayedNodes() {
        int n = this.sorter.getRowCount();
        UpdateResultNode[] ret = new UpdateResultNode[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = this.nodes[this.sorter.modelIndex(i)];
        }
        return ret;
    }

    public JComponent getComponent() {
        return this.component;
    }

    final void setColumns(String[] columns) {
        if (Arrays.equals(columns, this.tableColumns)) {
            return;
        }
        this.setDefaultColumnSizes();
        this.setModelProperties(columns);
        this.tableColumns = columns;
        for (int i = 0; i < this.tableColumns.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
            if (!"status".equals(this.tableColumns[i])) continue;
            this.sorter.setSortingStatus(i, 1);
            break;
        }
    }

    private void setModelProperties(String[] columns) {
        Node.Property[] properties = new Node.Property[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            String[] labels = this.columnLabels.get(column);
            properties[i] = new ColumnDescriptor(column, String.class, labels[0], labels[1]);
        }
        this.tableModel.setProperties(properties);
    }

    void setTableModel(UpdateResultNode[] nodes) {
        this.nodes = nodes;
        this.tableModel.setNodes((Node[])nodes);
    }

    void focus() {
        this.table.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick((MouseEvent)e)) {
            int row = this.table.rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            row = this.sorter.modelIndex(row);
            this.performOpen(row);
        }
    }

    private void onPopup(MouseEvent e) {
        final int[] selection = this.table.getSelectedRows();
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(UpdateResultsTable.class, (String)"CTL_MenuItem_Open")){
            {
                super(x0);
                this.setEnabled(selection.length == 1 && UpdateResultsTable.this.hasAction(selection, notDeletedEvaluator));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateResultsTable.this.performOpen(selection[0]);
            }
        }));
        menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(UpdateResultsTable.class, (String)"CTL_MenuItem_ResolveConflicts")){
            {
                super(x0);
                this.setEnabled(selection.length > -1 && UpdateResultsTable.this.hasAction(selection, conflictEvaluator));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ResolveConflictsAction.resolveConflicts(UpdateResultsTable.this.getSelectedFiles(selection));
            }
        }));
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    private boolean hasAction(int[] selection, ActionEvaluator ae) {
        for (int idx : selection) {
            int nodesIdx = this.sorter.modelIndex(idx);
            UpdateResultNode node = this.nodes[nodesIdx];
            FileUpdateInfo fui = (FileUpdateInfo)node.getLookup().lookup(FileUpdateInfo.class);
            if (fui != null && ae.isAction(fui)) continue;
            return false;
        }
        return true;
    }

    private void performOpen(int idx) {
        FileUpdateInfo fui = (FileUpdateInfo)this.nodes[idx].getLookup().lookup(FileUpdateInfo.class);
        if (fui == null) {
            return;
        }
        if ((fui.getAction() & FileUpdateInfo.ACTION_TYPE_FILE) != 0) {
            this.performOpenInEditorAction((Node)this.nodes[idx]);
        } else {
            this.performOpenSvnProperties(fui.getFile());
        }
    }

    private void performOpenInEditorAction(Node node) {
        Action action = node.getPreferredAction();
        if (action == null || !action.isEnabled()) {
            action = new OpenInEditorAction();
        }
        if (action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    private void performOpenSvnProperties(File file) {
        SvnPropertiesAction.openProperties(new File[]{file}, file.getName());
    }

    private File[] getSelectedFiles(int[] selection) {
        ArrayList<File> files = new ArrayList<File>();
        for (int idx : selection) {
            int nodesIdx = this.sorter.modelIndex(idx);
            UpdateResultNode node = this.nodes[nodesIdx];
            FileUpdateInfo fui = (FileUpdateInfo)node.getLookup().lookup(FileUpdateInfo.class);
            if (fui == null) continue;
            files.add(fui.getFile());
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        final ArrayList<UpdateResultNode> selectedNodes = new ArrayList<UpdateResultNode>();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        final TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.table);
        if (tc == null) {
            return;
        }
        int min = selectionModel.getMinSelectionIndex();
        if (min > -1) {
            int max = selectionModel.getMaxSelectionIndex();
            for (int i = min; i <= max; ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                int idx = this.sorter.modelIndex(i);
                selectedNodes.add(this.nodes[idx]);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tc.setActivatedNodes(selectedNodes.toArray(new Node[selectedNodes.size()]));
            }
        });
    }

    public void versioningEvent(VersioningEvent event) {
        if (this.nodes.length == 0) {
            return;
        }
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            UpdateResultNode[] currentNodes;
            File changedFile = (File)event.getParams()[0];
            FileInformation newFileInfo = (FileInformation)event.getParams()[2];
            final ArrayList<UpdateResultNode> nodesList = new ArrayList<UpdateResultNode>();
            boolean touched = false;
            for (UpdateResultNode node : currentNodes = this.nodes) {
                FileUpdateInfo fui = (FileUpdateInfo)node.getLookup().lookup(FileUpdateInfo.class);
                if (fui != null) {
                    int action = fui.getAction();
                    if ((action & ACTION_CONFLICTED_FILE) == ACTION_CONFLICTED_FILE && fui.getFile().equals(changedFile) && (newFileInfo.getStatus() & 0x4040) == 0) {
                        action &= ~FileUpdateInfo.ACTION_CONFLICTED;
                        FileUpdateInfo newFui = new FileUpdateInfo(fui.getFile(), action |= FileUpdateInfo.ACTION_CONFLICTED_RESOLVED);
                        nodesList.add(new UpdateResultNode(newFui));
                        touched = true;
                        continue;
                    }
                    nodesList.add(node);
                    continue;
                }
                nodesList.add(node);
            }
            if (!touched) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (currentNodes == UpdateResultsTable.this.nodes) {
                        UpdateResultsTable.this.setTableModel(nodesList.toArray(new UpdateResultNode[nodesList.size()]));
                    }
                }
            });
        }
    }

    private class SyncTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private SyncTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            int modelColumnIndex = table.convertColumnIndexToModel(column);
            if (modelColumnIndex == 0) {
                UpdateResultNode node = UpdateResultsTable.this.nodes[UpdateResultsTable.this.sorter.modelIndex(row)];
                if (!isSelected) {
                    value = "<html>" + node.getHtmlDisplayName();
                }
            }
            if ((renderer = modelColumnIndex == 2 ? this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                String path = UpdateResultsTable.this.nodes[UpdateResultsTable.this.sorter.modelIndex(row)].getInfo().getFile().getAbsolutePath();
                ((JComponent)renderer).setToolTipText(path);
            }
            return renderer;
        }
    }

    private static interface ActionEvaluator {
        public boolean isAction(FileUpdateInfo var1);
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

