/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.tree;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class FileTreeElement
implements TreeElement {
    private FileObject fo;

    FileTreeElement(FileObject fo) {
        this.fo = fo;
    }

    public TreeElement getParent(boolean isLogical) {
        if (isLogical) {
            return TreeElementFactory.getTreeElement((Object)this.fo.getParent());
        }
        Project p = FileOwnerQuery.getOwner((FileObject)this.fo);
        return TreeElementFactory.getTreeElement((Object)(p != null ? p : this.fo.getParent()));
    }

    public Icon getIcon() {
        try {
            return new ImageIcon(DataObject.find((FileObject)this.fo).getNodeDelegate().getIcon(1));
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    public String getText(boolean isLogical) {
        return this.fo.getNameExt();
    }

    public Object getUserObject() {
        return this.fo;
    }
}

