/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.spi;

import com.sun.source.tree.CompilationUnitTree;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class JavaRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    protected volatile boolean cancelRequest = false;
    private volatile CancellableTask currentTask;
    private WorkingTask workingTask = new WorkingTask();

    protected Problem preCheck(CompilationController compilationController) throws IOException {
        return null;
    }

    protected Problem checkParameters(CompilationController compilationController) throws IOException {
        return null;
    }

    protected Problem fastCheckParameters(CompilationController compilationController) throws IOException {
        return null;
    }

    protected abstract JavaSource getJavaSource(Phase var1);

    public Problem preCheck() {
        return this.workingTask.run(Phase.PRECHECK);
    }

    public Problem checkParameters() {
        return this.workingTask.run(Phase.CHECKPARAMETERS);
    }

    public Problem fastCheckParameters() {
        return this.workingTask.run(Phase.FASTCHECKPARAMETERS);
    }

    public void cancelRequest() {
        this.cancelRequest = true;
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        RetoucheUtils.cancel = true;
    }

    protected ClasspathInfo getClasspathInfo(AbstractRefactoring abstractRefactoring) {
        ClasspathInfo classpathInfo = (ClasspathInfo)abstractRefactoring.getContext().lookup(ClasspathInfo.class);
        if (classpathInfo == null) {
            Collection collection = abstractRefactoring.getRefactoringSource().lookupAll(TreePathHandle.class);
            classpathInfo = !collection.isEmpty() ? RetoucheUtils.getClasspathInfoFor(collection.toArray(new TreePathHandle[collection.size()])) : RetoucheUtils.getClasspathInfoFor(new FileObject[]{null});
            abstractRefactoring.getContext().add((Object)classpathInfo);
        }
        return classpathInfo;
    }

    protected static final Problem createProblem(Problem problem, boolean bl, String string) {
        Problem problem2 = new Problem(bl, string);
        if (problem == null) {
            return problem2;
        }
        if (bl) {
            problem2.setNext(problem);
            return problem2;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    protected static Problem isElementAvail(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
        String string;
        if (treePathHandle == null) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElNotAvail"));
        }
        Element element = treePathHandle.resolveElement(compilationInfo);
        String string2 = string = element != null ? element.getSimpleName().toString() : null;
        if (element == null || element.asType().getKind() == TypeKind.ERROR || "<error>".equals(string)) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElementNotResolved"));
        }
        if ("this".equals(string) || "super".equals(string)) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"ERR_CannotRefactorThis", (Object)element.getSimpleName()));
        }
        return null;
    }

    private Iterable<? extends List<FileObject>> groupByRoot(Iterable<? extends FileObject> iterable) {
        HashMap<FileObject, LinkedList<FileObject>> hashMap = new HashMap<FileObject, LinkedList<FileObject>>();
        for (FileObject fileObject : iterable) {
            FileObject fileObject2;
            if (this.cancelRequest) {
                return Collections.emptyList();
            }
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (classPath == null || (fileObject2 = classPath.findOwnerRoot(fileObject)) == null) continue;
            LinkedList<FileObject> linkedList = (LinkedList<FileObject>)hashMap.get(fileObject2);
            if (linkedList == null) {
                linkedList = new LinkedList<FileObject>();
                hashMap.put(fileObject2, linkedList);
            }
            linkedList.add(fileObject);
        }
        return hashMap.values();
    }

    protected final Collection<ModificationResult> processFiles(Set<FileObject> set, CancellableTask<WorkingCopy> cancellableTask) throws IOException {
        return this.processFiles(set, cancellableTask, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Collection<ModificationResult> processFiles(Set<FileObject> set, CancellableTask<WorkingCopy> cancellableTask, ClasspathInfo classpathInfo) throws IOException {
        this.currentTask = cancellableTask;
        LinkedList<ModificationResult> linkedList = new LinkedList<ModificationResult>();
        try {
            Iterable<? extends List<FileObject>> iterable = this.groupByRoot(set);
            for (List<FileObject> list : iterable) {
                JavaSource javaSource;
                if (this.cancelRequest) {
                    javaSource = Collections.emptyList();
                    return javaSource;
                }
                javaSource = JavaSource.create((ClasspathInfo)(classpathInfo == null ? ClasspathInfo.create((FileObject)list.get(0)) : classpathInfo), list);
                linkedList.add(javaSource.runModificationTask(cancellableTask));
            }
        }
        finally {
            this.currentTask = null;
        }
        return linkedList;
    }

    protected final Problem createAndAddElements(Set<FileObject> set, CancellableTask<WorkingCopy> cancellableTask, RefactoringElementsBag refactoringElementsBag, AbstractRefactoring abstractRefactoring, ClasspathInfo classpathInfo) {
        try {
            Collection<ModificationResult> collection = this.processFiles(set, cancellableTask, classpathInfo);
            refactoringElementsBag.registerTransaction((Transaction)new RetoucheCommit(collection));
            for (ModificationResult modificationResult : collection) {
                for (FileObject fileObject : modificationResult.getModifiedFileObjects()) {
                    for (ModificationResult.Difference difference : modificationResult.getDifferences(fileObject)) {
                        refactoringElementsBag.add(abstractRefactoring, (RefactoringElementImplementation)DiffElement.create(difference, fileObject, modificationResult));
                    }
                }
            }
        }
        catch (IOException iOException) {
            return this.createProblemAndLog(null, iOException);
        }
        return null;
    }

    protected final Problem createAndAddElements(Set<FileObject> set, CancellableTask<WorkingCopy> cancellableTask, RefactoringElementsBag refactoringElementsBag, AbstractRefactoring abstractRefactoring) {
        return this.createAndAddElements(set, cancellableTask, refactoringElementsBag, abstractRefactoring, null);
    }

    protected final Problem createProblemAndLog(Problem problem, Throwable throwable) {
        String string;
        Problem problem2;
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null && (throwable2.getClass().getName().equals("org.netbeans.api.java.source.JavaSource$InsufficientMemoryException") || throwable2.getCause() != null && throwable2.getCause().getClass().getName().equals("org.netbeans.api.java.source.JavaSource$InsufficientMemoryException"))) {
            problem2 = new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_OutOfMemory"));
        } else {
            string = NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ExceptionThrown", (Object)throwable.toString());
            problem2 = new Problem(true, string);
        }
        Exceptions.printStackTrace((Throwable)throwable);
        if (problem == null) {
            return problem2;
        }
        string = problem;
        while (string.getNext() != null) {
            string = string.getNext();
        }
        string.setNext(problem2);
        return problem;
    }

    protected class TransformTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringVisitor visitor;
        private TreePathHandle treePathHandle;

        public TransformTask(RefactoringVisitor refactoringVisitor, TreePathHandle treePathHandle) {
            this.visitor = refactoringVisitor;
            this.treePathHandle = treePathHandle;
        }

        public void cancel() {
        }

        public void run(WorkingCopy workingCopy) throws IOException {
            try {
                this.visitor.setWorkingCopy(workingCopy);
            }
            catch (ToPhaseException toPhaseException) {
                return;
            }
            CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
            if (compilationUnitTree == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + workingCopy);
                return;
            }
            Element element = null;
            if (this.treePathHandle != null && (element = this.treePathHandle.resolveElement((CompilationInfo)workingCopy)) == null) {
                Logger.getLogger("org.netbeans.modules.refactoring.java").info("Cannot resolve " + this.treePathHandle + "in " + workingCopy.getFileObject().getPath());
            }
            this.visitor.scan(workingCopy.getCompilationUnit(), element);
            JavaRefactoringPlugin.this.fireProgressListenerStep();
        }
    }

    private class WorkingTask
    implements Task<CompilationController> {
        private Phase whatRun;
        private Problem problem;

        private WorkingTask() {
        }

        private Problem run(Phase phase) {
            this.whatRun = phase;
            this.problem = null;
            JavaSource javaSource = JavaRefactoringPlugin.this.getJavaSource(phase);
            if (javaSource == null) {
                return null;
            }
            try {
                javaSource.runUserActionTask((Task)this, true);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return this.problem;
        }

        public void run(CompilationController compilationController) throws Exception {
            switch (this.whatRun) {
                case PRECHECK: {
                    this.problem = JavaRefactoringPlugin.this.preCheck(compilationController);
                    break;
                }
                case CHECKPARAMETERS: {
                    this.problem = JavaRefactoringPlugin.this.checkParameters(compilationController);
                    break;
                }
                case FASTCHECKPARAMETERS: {
                    this.problem = JavaRefactoringPlugin.this.fastCheckParameters(compilationController);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    protected static enum Phase {
        PRECHECK,
        FASTCHECKPARAMETERS,
        CHECKPARAMETERS,
        PREPARE;

    }
}

