/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;

public class RenameTransformer
extends RefactoringVisitor {
    private Set<ElementHandle<ExecutableElement>> allMethods;
    private String newName;
    private boolean renameInComments;

    public RenameTransformer(String string, Set<ElementHandle<ExecutableElement>> set, boolean bl) {
        this.newName = string;
        this.allMethods = set;
        this.renameInComments = bl;
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree compilationUnitTree, Element element) {
        if (!this.renameInComments) {
            return (Tree)super.visitCompilationUnit(compilationUnitTree, element);
        }
        if (element.getKind() == ElementKind.PARAMETER) {
            this.renameParameterInMethodComments(element);
        } else {
            String string = this.getOldSimpleName(element);
            if (string != null) {
                TokenSequence tokenSequence = this.workingCopy.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                while (tokenSequence.moveNext()) {
                    Token token = tokenSequence.token();
                    if (!this.isComment((Token<JavaTokenId>)token)) continue;
                    this.rewriteAllInComment(((Object)token.text()).toString(), tokenSequence.offset(), string);
                }
            }
        }
        return (Tree)super.visitCompilationUnit(compilationUnitTree, element);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree identifierTree, Element element) {
        this.renameUsageIfMatch(this.getCurrentPath(), identifierTree, element);
        return (Tree)super.visitIdentifier(identifierTree, element);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Element element) {
        this.renameUsageIfMatch(this.getCurrentPath(), memberSelectTree, element);
        return (Tree)super.visitMemberSelect(memberSelectTree, element);
    }

    private String getOldSimpleName(Element element) {
        if (element != null) {
            return element.getSimpleName().toString();
        }
        for (ElementHandle<ExecutableElement> elementHandle : this.allMethods) {
            ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)this.workingCopy);
            if (executableElement == null) continue;
            return executableElement.getSimpleName().toString();
        }
        return null;
    }

    private void renameUsageIfMatch(TreePath treePath, Tree tree, Element element) {
        Iterator iterator;
        Object object;
        Object object2;
        if (this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
            return;
        }
        Trees trees = this.workingCopy.getTrees();
        Element element2 = this.workingCopy.getTrees().getElement(treePath);
        if (element2 == null) {
            if ((treePath = treePath.getParentPath()) != null && treePath.getLeaf().getKind() == Tree.Kind.IMPORT) {
                object2 = (ImportTree)treePath.getLeaf();
                if (!object2.isStatic()) {
                    return;
                }
                object = object2.getQualifiedIdentifier();
                if (object.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return;
                }
                final Name name = ((MemberSelectTree)object).getIdentifier();
                if (name == null || name.contentEquals("*")) {
                    return;
                }
                ExpressionTree object3 = ((MemberSelectTree)object).getExpression();
                treePath = trees.getPath(this.workingCopy.getCompilationUnit(), object3);
                element2 = trees.getElement(treePath);
                if (element2 == null) {
                    return;
                }
                iterator = this.workingCopy.getElementUtilities().getMembers(element2.asType(), new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element element, TypeMirror typeMirror) {
                        return ((Object)name).equals(element.getSimpleName());
                    }
                }).iterator();
                if (iterator.hasNext()) {
                    element2 = (Element)iterator.next();
                }
                if (iterator.hasNext()) {
                    return;
                }
            } else {
                return;
            }
        }
        if (((Object)element2).equals(element) || this.isMethodMatch(element2)) {
            object2 = null;
            if (element != null && element.getKind().isField()) {
                object = this.workingCopy.getTrees().getScope(treePath);
                for (Element element3 : object.getLocalElements()) {
                    if (element3.getKind() != ElementKind.LOCAL_VARIABLE && element3.getKind() != ElementKind.PARAMETER || !element3.getSimpleName().toString().equals(this.newName)) continue;
                    if (tree.getKind() == Tree.Kind.MEMBER_SELECT && (((String)((Object)(iterator = ((MemberSelectTree)tree).getExpression().toString()))).equals("this") || ((String)((Object)iterator)).endsWith(".this"))) break;
                    if (object.getEnclosingClass().equals(element.getEnclosingElement())) {
                        object2 = "this.";
                        break;
                    }
                    object2 = element.getEnclosingElement().getSimpleName() + ".this.";
                    break;
                }
            }
            object = object2 != null ? this.make.setLabel(tree, (CharSequence)((String)object2 + this.newName)) : this.make.setLabel(tree, (CharSequence)this.newName);
            this.rewrite(tree, (Tree)object);
        }
    }

    @Override
    public Tree visitMethod(MethodTree methodTree, Element element) {
        this.renameDeclIfMatch(this.getCurrentPath(), methodTree, element);
        return (Tree)super.visitMethod(methodTree, element);
    }

    @Override
    public Tree visitClass(ClassTree classTree, Element element) {
        this.renameDeclIfMatch(this.getCurrentPath(), classTree, element);
        return (Tree)super.visitClass(classTree, element);
    }

    @Override
    public Tree visitVariable(VariableTree variableTree, Element element) {
        this.renameDeclIfMatch(this.getCurrentPath(), variableTree, element);
        return (Tree)super.visitVariable(variableTree, element);
    }

    @Override
    public Tree visitTypeParameter(TypeParameterTree typeParameterTree, Element element) {
        this.renameDeclIfMatch(this.getCurrentPath(), typeParameterTree, element);
        return (Tree)super.visitTypeParameter(typeParameterTree, element);
    }

    private void renameDeclIfMatch(TreePath treePath, Tree tree, Element element) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
            return;
        }
        Element element2 = this.workingCopy.getTrees().getElement(treePath);
        if (element2 == null) {
            return;
        }
        if (((Object)element2).equals(element) || this.isMethodMatch(element2)) {
            Tree tree2 = this.make.setLabel(tree, (CharSequence)this.newName);
            this.rewrite(tree, tree2);
            return;
        }
    }

    private boolean isMethodMatch(Element element) {
        if (element.getKind() == ElementKind.METHOD && this.allMethods != null) {
            for (ElementHandle<ExecutableElement> elementHandle : this.allMethods) {
                ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)this.workingCopy);
                if (executableElement == null) {
                    Logger.getLogger("org.netbeans.modules.refactoring.java").info("RenameTransformer cannot resolve " + elementHandle);
                    continue;
                }
                if (!executableElement.equals(element) && !this.workingCopy.getElements().overrides((ExecutableElement)element, executableElement, this.workingCopy.getElementUtilities().enclosingTypeElement((Element)executableElement))) continue;
                return true;
            }
        }
        return false;
    }

    private void renameParameterInMethodComments(Element element) {
        Tree tree = this.workingCopy.getTrees().getPath(element).getParentPath().getLeaf();
        String string = this.getOldSimpleName(element);
        int n = (int)this.workingCopy.getTrees().getSourcePositions().getStartPosition(this.workingCopy.getCompilationUnit(), tree);
        TokenSequence tokenSequence = this.workingCopy.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(n);
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            if (this.isComment((Token<JavaTokenId>)token)) {
                this.rewriteAllInComment(((Object)token.text()).toString(), tokenSequence.offset(), string);
                continue;
            }
            if (token.id() == JavaTokenId.WHITESPACE) continue;
            break;
        }
        int n2 = (int)this.workingCopy.getTrees().getSourcePositions().getEndPosition(this.workingCopy.getCompilationUnit(), tree);
        tokenSequence.move(n);
        while (tokenSequence.moveNext() && tokenSequence.offset() < n2) {
            Token token = tokenSequence.token();
            if (!this.isComment((Token<JavaTokenId>)token)) continue;
            this.rewriteAllInComment(((Object)token.text()).toString(), tokenSequence.offset(), string);
        }
    }

    private boolean isComment(Token<JavaTokenId> token) {
        switch ((JavaTokenId)token.id()) {
            case LINE_COMMENT: 
            case BLOCK_COMMENT: 
            case JAVADOC_COMMENT: {
                return true;
            }
        }
        return false;
    }

    private void rewriteAllInComment(String string, int n, String string2) {
        int n2 = string.indexOf(string2);
        while (n2 != -1) {
            if (!(n2 > 0 && Character.isJavaIdentifierPart(string.charAt(n2 - 1)) || n2 + string2.length() < string.length() && Character.isJavaIdentifierPart(string.charAt(n2 + string2.length())))) {
                this.workingCopy.rewriteInComment(n + n2, string2.length(), this.newName);
            }
            n2 = string.indexOf(string2, n2 + 1);
        }
    }
}

