/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.server.manager.ui;

import javax.swing.Action;
import org.netbeans.modules.identity.server.manager.api.ServerInstance;
import org.netbeans.modules.identity.server.manager.ui.ProfilesNode;
import org.netbeans.modules.identity.server.manager.ui.actions.CustomizerAction;
import org.netbeans.modules.identity.server.manager.ui.actions.ViewAdminConsoleAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ServerInstanceNode
extends AbstractNode {
    private static final String SERVER_INSTANCE_ICON = "org/netbeans/modules/identity/server/manager/ui/resources/ServerInstance.png";
    private static final String HELP_ID = "idmtools_am_ww_am_instances";
    private ServerInstance instance;

    public ServerInstanceNode(ServerInstance serverInstance) {
        super((Children)new ServerInstanceChildren(serverInstance));
        this.instance = serverInstance;
        this.setName(serverInstance.getID());
        this.setDisplayName(NbBundle.getMessage(ServerInstanceNode.class, (String)"LBL_ServerInstanceNode"));
        this.setIconBaseWithExtension(SERVER_INSTANCE_ICON);
        this.setShortDescription(NbBundle.getMessage(ServerInstanceNode.class, (String)"DESC_ServerInstanceNode", (Object)serverInstance.getHost()));
    }

    public Action[] getActions(boolean bl) {
        Action[] actionArray = new Action[]{SystemAction.get(ViewAdminConsoleAction.class), null, SystemAction.get(CustomizerAction.class)};
        return actionArray;
    }

    public ServerInstance getInstance() {
        return this.instance;
    }

    public String getAdminURL() {
        return this.instance.getAdminURL();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    private static class ServerInstanceChildren
    extends Children.Keys {
        private static final String PROFILES_NODE_KEY = "Profiles";
        private ServerInstance instance;

        public ServerInstanceChildren(ServerInstance serverInstance) {
            this.instance = serverInstance;
        }

        protected void addNotify() {
            this.setKeys(new String[]{PROFILES_NODE_KEY});
        }

        protected Node[] createNodes(Object object) {
            if (object.equals(PROFILES_NODE_KEY)) {
                return new Node[]{new ProfilesNode(this.instance)};
            }
            return null;
        }
    }
}

