/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview.model;

import java.util.Collection;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.classview.actions.GoToDeclarationAction;
import org.netbeans.modules.cnd.classview.actions.MoreDeclarations;
import org.netbeans.modules.cnd.classview.model.CVUtil;
import org.netbeans.modules.cnd.classview.model.NPNode;
import org.openide.nodes.Children;

public class NamespaceNode
extends NPNode {
    private String id;
    private CsmProject project;

    public NamespaceNode(CsmNamespace ns, Children.Array key) {
        super(key);
        this.init(ns);
    }

    private void init(CsmNamespace ns) {
        this.id = ((Object)ns.getQualifiedName()).toString();
        this.project = ns.getProject();
        String name = ((Object)ns.getQualifiedName()).toString();
        String displayName = ((Object)CVUtil.getNamespaceDisplayName(ns)).toString();
        this.setName(name);
        this.setDisplayName(displayName);
        this.setShortDescription(((Object)ns.getQualifiedName()).toString());
    }

    @Override
    public CsmNamespace getNamespace() {
        return this.project.findNamespace((CharSequence)this.id);
    }

    public String getHtmlDisplayName() {
        String retValue = this.getDisplayName();
        if (retValue.startsWith(" ")) {
            retValue = "<i>" + retValue;
        }
        return retValue;
    }

    public Action getPreferredAction() {
        return this.createOpenAction();
    }

    private Action createOpenAction() {
        Collection arr;
        CsmNamespace ns = this.getNamespace();
        if (ns != null && (arr = ns.getDefinitions()).size() > 0) {
            return new GoToDeclarationAction((CsmOffsetable)arr.iterator().next());
        }
        return null;
    }

    public Action[] getActions(boolean context) {
        Action action = this.createOpenAction();
        if (action != null) {
            CsmNamespace ns = this.getNamespace();
            Collection arr = ns.getDefinitions();
            if (arr.size() > 1) {
                MoreDeclarations more = new MoreDeclarations(arr);
                return new Action[]{action, more};
            }
            return new Action[]{action};
        }
        return new Action[0];
    }
}

