/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview.actions;

import java.util.Iterator;
import javax.swing.JEditorPane;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;

public class ContextUtils {
    private ContextUtils() {
    }

    public static CsmOffsetableDeclaration getContext(Node[] activatedNodes) {
        if (activatedNodes != null && activatedNodes.length > 0) {
            return ContextUtils.findDeclaration(activatedNodes[0]);
        }
        return null;
    }

    private static CsmOffsetableDeclaration findDeclaration(Node activatedNode) {
        JEditorPane pane;
        EditorCookie c = (EditorCookie)activatedNode.getCookie(EditorCookie.class);
        if (c != null && (pane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)c)) != null) {
            int offset = pane.getCaret().getDot();
            CsmFile file = CsmUtilities.getCsmFile((Node)activatedNode, (boolean)false);
            if (file != null) {
                return ContextUtils.findInnerFileDeclaration(file, offset);
            }
        }
        return null;
    }

    private static CsmOffsetableDeclaration findInnerFileDeclaration(CsmFile file, int offset) {
        CsmOffsetableDeclaration innerDecl = null;
        if (innerDecl == null) {
            for (CsmOffsetableDeclaration decl : file.getDeclarations()) {
                if (!ContextUtils.isInObject((CsmObject)decl, offset)) continue;
                innerDecl = ContextUtils.findInnerDeclaration(decl, offset);
                innerDecl = innerDecl != null ? innerDecl : decl;
                break;
            }
        }
        return innerDecl;
    }

    private static CsmOffsetableDeclaration findInnerDeclaration(CsmOffsetableDeclaration outDecl, int offset) {
        Iterator it = null;
        CsmOffsetableDeclaration innerDecl = null;
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)outDecl)) {
            it = ((CsmNamespaceDefinition)outDecl).getDeclarations().iterator();
        } else if (CsmKindUtilities.isClass((CsmObject)outDecl)) {
            CsmClass cl = (CsmClass)outDecl;
            it = cl.getMembers().iterator();
        }
        if (it != null) {
            while (it.hasNext()) {
                CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)it.next();
                if (!ContextUtils.isInObject((CsmObject)decl, offset)) continue;
                innerDecl = ContextUtils.findInnerDeclaration(decl, offset);
                innerDecl = innerDecl != null ? innerDecl : decl;
                break;
            }
        }
        return innerDecl;
    }

    private static boolean isInObject(CsmObject obj, int offset) {
        if (!CsmKindUtilities.isOffsetable((Object)obj)) {
            return false;
        }
        CsmOffsetable offs = (CsmOffsetable)obj;
        return offs.getStartOffset() <= offset && offset <= offs.getEndOffset();
    }
}

