/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Collections;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.classview.ClassViewModel;
import org.netbeans.modules.cnd.classview.Diagnostic;
import org.netbeans.modules.cnd.classview.ProjectsKeyArray;
import org.netbeans.modules.cnd.classview.RootNode;
import org.netbeans.modules.cnd.classview.resources.I18n;
import org.netbeans.modules.cnd.modelutil.AbstractCsmNode;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ClassView
extends JComponent
implements ExplorerManager.Provider,
Accessible,
PropertyChangeListener,
Lookup.Provider {
    protected BeanTreeView view;
    private ClassViewModel model;
    private ViewMouseListener mouseListener = new ViewMouseListener();
    private final ExplorerManager manager = new ExplorerManager();
    private final InstanceContent selectedNodes = new InstanceContent();
    private final Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.selectedNodes);
    private static final boolean TRACE_MODEL_CHANGE_EVENTS = Boolean.getBoolean("cnd.classview.trace.events");
    private Timer userActivity = null;
    private static final int USER_MOUSE_ACTIVITY_DELAY = 2000;

    public ClassView() {
        this.setLayout(new BorderLayout());
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        this.setupRootContext(this.createEmptyRoot());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            this.selectedNodes.setPairs(Collections.emptyList());
            for (Node n : (Node[])evt.getNewValue()) {
                CsmObject csmObject;
                this.selectedNodes.add((Object)n);
                if (!(n instanceof AbstractCsmNode) || (csmObject = ((AbstractCsmNode)n).getCsmObject()) == null) continue;
                this.selectedNodes.add((Object)csmObject);
            }
        }
    }

    void selectInClasses(final CsmOffsetableDeclaration decl) {
        CsmModelAccessor.getModel().enqueue(new Runnable(){

            @Override
            public void run() {
                Node node;
                ClassViewModel currentModel = ClassView.this.getModel();
                if (currentModel != null && (node = currentModel.findDeclaration(decl)) != null) {
                    try {
                        ClassView.this.setUserActivity();
                        ClassView.this.getExplorerManager().setSelectedNodes(new Node[]{node});
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }, (CharSequence)"Class View: select in classes");
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private void init() {
        this.view = new BeanTreeView();
        this.view.setRootVisible(false);
        this.view.setDragSource(true);
        this.add((Component)this.view, "Center");
        this.setToolTipText(I18n.getMessage("ClassViewTitle"));
        this.setName(I18n.getMessage("ClassViewTooltip"));
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }

                @Override
                public String getAccessibleName() {
                    if (this.accessibleName != null) {
                        return this.accessibleName;
                    }
                    return ClassView.this.getName();
                }

                @Override
                public String getToolTipText() {
                    return ClassView.this.getToolTipText();
                }
            };
        }
        return this.accessibleContext;
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.view.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.view.requestFocus();
    }

    private void addRemoveViewListeners(boolean add) {
        JViewport port;
        Object comp;
        Component[] scroll = this.view.getComponents();
        if (scroll != null) {
            for (int i = 0; i < scroll.length; ++i) {
                comp = scroll[i];
                if (!(comp instanceof JScrollBar)) continue;
                if (add) {
                    ((Component)comp).addMouseListener(this.mouseListener);
                    ((Component)comp).addMouseMotionListener(this.mouseListener);
                    continue;
                }
                ((Component)comp).removeMouseListener(this.mouseListener);
                ((Component)comp).removeMouseMotionListener(this.mouseListener);
            }
        }
        if ((comp = (port = this.view.getViewport()).getComponents()) != null && ((Component[])comp).length > 0) {
            if (add) {
                comp[0].addMouseListener(this.mouseListener);
                ((Component)comp[0]).addMouseMotionListener(this.mouseListener);
            } else {
                comp[0].removeMouseListener(this.mouseListener);
                ((Component)comp[0]).removeMouseMotionListener(this.mouseListener);
            }
        }
    }

    private void setUserActivity() {
        if (this.userActivity == null) {
            this.userActivity = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ClassView.this.stopViewModify();
                }
            });
        }
        this.userActivity.restart();
        ClassViewModel currentModel = this.getModel();
        if (currentModel != null && !currentModel.isUserActivity()) {
            currentModel.setUserActivity(true);
        }
    }

    private void stopViewModify() {
        ClassViewModel currentModel = this.getModel();
        if (currentModel != null) {
            currentModel.setUserActivity(false);
        }
        if (this.userActivity != null) {
            this.userActivity.stop();
        }
    }

    void startup() {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesV: startup()");
        }
        ClassViewModel currentModel = this.getModel();
        this.setModel(new ClassViewModel());
        if (currentModel != null) {
            currentModel.dispose();
        }
        this.init();
        this.addRemoveViewListeners(true);
        if (CsmModelAccessor.getModel().projects().isEmpty()) {
            this.setupRootContext(this.createEmptyRoot());
        } else {
            this.setupRootContext((Node)this.getModel().getRoot());
        }
    }

    void shutdown() {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesV: shutdown()");
        }
        this.addRemoveViewListeners(false);
        ClassViewModel currentModel = this.getModel();
        if (currentModel != null) {
            currentModel.dispose();
            this.setModel(null);
        }
        this.stopViewModify();
        this.remove((Component)this.view);
        this.view = null;
        this.userActivity = null;
        this.mouseListener = null;
        this.setupRootContext(this.createEmptyRoot());
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    void projectOpened(CsmProject project) {
        ClassViewModel currentModel;
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesV: projectOpened() " + project);
        }
        if ((currentModel = this.getModel()) != null) {
            currentModel.openProject(project);
            this.setupRootContext((Node)currentModel.getRoot());
        }
    }

    void projectClosed(CsmProject project) {
        ClassViewModel currentModel;
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesV: projectClosed() " + project);
        }
        if ((currentModel = this.getModel()) != null && !this.getExplorerManager().getRootContext().isLeaf()) {
            currentModel.closeProject(project);
            RootNode root = currentModel.getRoot();
            Children children = root.getChildren();
            if (children instanceof ProjectsKeyArray && ((ProjectsKeyArray)children).isEmpty()) {
                this.setupRootContext(this.createEmptyRoot());
            } else {
                this.setupRootContext((Node)root);
            }
        }
    }

    void modelChanged(CsmChangeEvent e) {
        ClassViewModel currentModel;
        if (TRACE_MODEL_CHANGE_EVENTS) {
            new CsmTracer().dumpModelChangeEvent(e);
        }
        if ((currentModel = this.getModel()) != null) {
            currentModel.scheduleUpdate(e);
        }
    }

    private Node createEmptyRoot() {
        return Node.EMPTY;
    }

    private void setupRootContext(Node rc) {
        if (this.getExplorerManager().getRootContext() != rc) {
            try {
                this.getExplorerManager().setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
            if (Diagnostic.DEBUG) {
                Diagnostic.trace("ClassesV: setupRootContext() " + rc);
            }
            this.getExplorerManager().setRootContext(rc);
        }
    }

    private ClassViewModel getModel() {
        return this.model;
    }

    private void setModel(ClassViewModel model) {
        this.model = model;
    }

    private class ViewMouseListener
    implements MouseListener,
    MouseMotionListener {
        private ViewMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ClassView.this.setUserActivity();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ClassView.this.setUserActivity();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ClassView.this.setUserActivity();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ClassView.this.setUserActivity();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ClassView.this.setUserActivity();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ClassView.this.setUserActivity();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ClassView.this.setUserActivity();
        }
    }
}

