/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.Serializable;
import java.util.Date;
import org.tigris.subversion.javahl.ConflictDescriptor;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.StatusKind;

public class Status
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String url;
    private String path;
    private int nodeKind;
    private long revision;
    private long lastChangedRevision;
    private long lastChangedDate;
    private String lastCommitAuthor;
    private int textStatus;
    private int propStatus;
    private boolean locked;
    private boolean copied;
    private boolean switched;
    private boolean fileExternal;
    private boolean treeConflicted;
    private ConflictDescriptor conflictDescriptor;
    private int repositoryTextStatus;
    private int repositoryPropStatus;
    private String conflictNew;
    private String conflictOld;
    private String conflictWorking;
    private String urlCopiedFrom;
    private long revisionCopiedFrom;
    private String lockToken;
    private String lockOwner;
    private String lockComment;
    private long lockCreationDate;
    private Lock reposLock;
    private long reposLastCmtRevision = -1L;
    private long reposLastCmtDate = 0L;
    private int reposKind = 0;
    private String reposLastCmtAuthor;
    private String changelist;

    public Status(String path, String url, int nodeKind, long revision, long lastChangedRevision, long lastChangedDate, String lastCommitAuthor, int textStatus, int propStatus, int repositoryTextStatus, int repositoryPropStatus, boolean locked, boolean copied, boolean treeConflicted, ConflictDescriptor conflictDescriptor, String conflictOld, String conflictNew, String conflictWorking, String urlCopiedFrom, long revisionCopiedFrom, boolean switched, boolean fileExternal, String lockToken, String lockOwner, String lockComment, long lockCreationDate, Lock reposLock, long reposLastCmtRevision, long reposLastCmtDate, int reposKind, String reposLastCmtAuthor, String changelist) {
        this.path = path;
        this.url = url;
        this.nodeKind = nodeKind;
        this.revision = revision;
        this.lastChangedRevision = lastChangedRevision;
        this.lastChangedDate = lastChangedDate;
        this.lastCommitAuthor = lastCommitAuthor;
        this.textStatus = textStatus;
        this.propStatus = propStatus;
        this.locked = locked;
        this.copied = copied;
        this.treeConflicted = treeConflicted;
        this.conflictDescriptor = conflictDescriptor;
        this.repositoryTextStatus = repositoryTextStatus;
        this.repositoryPropStatus = repositoryPropStatus;
        this.conflictOld = conflictOld;
        this.conflictNew = conflictNew;
        this.conflictWorking = conflictWorking;
        this.urlCopiedFrom = urlCopiedFrom;
        this.revisionCopiedFrom = revisionCopiedFrom;
        this.switched = switched;
        this.fileExternal = fileExternal;
        this.lockToken = lockToken;
        this.lockOwner = lockOwner;
        this.lockComment = lockComment;
        this.lockCreationDate = lockCreationDate;
        this.reposLock = reposLock;
        this.reposLastCmtRevision = reposLastCmtRevision;
        this.reposLastCmtDate = reposLastCmtDate;
        this.reposKind = reposKind;
        this.reposLastCmtAuthor = reposLastCmtAuthor;
        this.changelist = changelist;
    }

    public String getPath() {
        return this.path;
    }

    public Revision.Number getRevision() {
        return Revision.createNumber(this.revision);
    }

    public long getRevisionNumber() {
        return this.revision;
    }

    public Date getLastChangedDate() {
        return Status.microsecondsToDate(this.lastChangedDate);
    }

    public long getLastChangedDateMicros() {
        return this.lastChangedDate;
    }

    public String getLastCommitAuthor() {
        return this.lastCommitAuthor;
    }

    public int getTextStatus() {
        return this.textStatus;
    }

    public String getTextStatusDescription() {
        return Kind.getDescription(this.textStatus);
    }

    public int getPropStatus() {
        return this.propStatus;
    }

    public String getPropStatusDescription() {
        return Kind.getDescription(this.propStatus);
    }

    public int getRepositoryTextStatus() {
        return this.repositoryTextStatus;
    }

    public int getRepositoryPropStatus() {
        return this.repositoryPropStatus;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public String getConflictNew() {
        return this.conflictNew;
    }

    public String getConflictOld() {
        return this.conflictOld;
    }

    public String getConflictWorking() {
        return this.conflictWorking;
    }

    public String getUrl() {
        return this.url;
    }

    public Revision.Number getLastChangedRevision() {
        return Revision.createNumber(this.lastChangedRevision);
    }

    public long getLastChangedRevisionNumber() {
        return this.lastChangedRevision;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public String getUrlCopiedFrom() {
        return this.urlCopiedFrom;
    }

    public Revision.Number getRevisionCopiedFrom() {
        return Revision.createNumber(this.revisionCopiedFrom);
    }

    public long getRevisionCopiedFromNumber() {
        return this.revisionCopiedFrom;
    }

    public boolean isSwitched() {
        return this.switched;
    }

    public boolean isFileExternal() {
        return this.fileExternal;
    }

    public boolean isManaged() {
        int status = this.getTextStatus();
        return status != 5 && status != 0 && status != 11;
    }

    public boolean hasRemote() {
        return this.isManaged() && this.getTextStatus() != 3;
    }

    public boolean isAdded() {
        return this.getTextStatus() == 3;
    }

    public boolean isDeleted() {
        return this.getTextStatus() == 4;
    }

    public boolean isMerged() {
        return this.getTextStatus() == 8;
    }

    public boolean isIgnored() {
        return this.getTextStatus() == 11;
    }

    public boolean isModified() {
        return this.getTextStatus() == 2;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public String getLockComment() {
        return this.lockComment;
    }

    public Date getLockCreationDate() {
        return Status.microsecondsToDate(this.lockCreationDate);
    }

    public long getLockCreationDateMicros() {
        return this.lockCreationDate;
    }

    public Lock getReposLock() {
        return this.reposLock;
    }

    public Revision.Number getReposLastCmtRevision() {
        return Revision.createNumber(this.reposLastCmtRevision);
    }

    public long getReposLastCmtRevisionNumber() {
        return this.reposLastCmtRevision;
    }

    public Date getReposLastCmtDate() {
        return Status.microsecondsToDate(this.reposLastCmtDate);
    }

    public long getReposLastCmtDateMicros() {
        return this.reposLastCmtDate;
    }

    public int getReposKind() {
        return this.reposKind;
    }

    public String getReposLastCmtAuthor() {
        return this.reposLastCmtAuthor;
    }

    public String getChangelist() {
        return this.changelist;
    }

    public boolean hasTreeConflict() {
        return this.treeConflicted;
    }

    public ConflictDescriptor getConflictDescriptor() {
        return this.conflictDescriptor;
    }

    private static Date microsecondsToDate(long micros) {
        return micros == 0L ? null : new Date(micros / 1000L);
    }

    public static final class Kind
    implements StatusKind {
        public static final String getDescription(int kind) {
            switch (kind) {
                case 0: {
                    return "non-svn";
                }
                case 1: {
                    return "normal";
                }
                case 3: {
                    return "added";
                }
                case 6: {
                    return "missing";
                }
                case 4: {
                    return "deleted";
                }
                case 7: {
                    return "replaced";
                }
                case 2: {
                    return "modified";
                }
                case 8: {
                    return "merged";
                }
                case 9: {
                    return "conflicted";
                }
                case 11: {
                    return "ignored";
                }
                case 12: {
                    return "incomplete";
                }
                case 13: {
                    return "external";
                }
            }
            return "unversioned";
        }
    }
}

