/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.netbeans.util.Util;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;

final class CopyFiles {
    private File sourceRoot;
    private File targetRoot;
    private EditableProperties currentProperties;
    private Set<String> includePatterns = new HashSet<String>();
    private Set<String> excludePatterns = new HashSet<String>();
    private static final Logger LOGGER = Logger.getLogger(CopyFiles.class.getName());

    private CopyFiles(File source, File target, File patternsFile) {
        this.sourceRoot = source;
        this.targetRoot = target;
        try {
            FileInputStream is = new FileInputStream(patternsFile);
            InputStreamReader reader = new InputStreamReader((InputStream)is, "utf-8");
            this.readPatterns(reader);
            ((Reader)reader).close();
        }
        catch (IOException ex) {
            JDialog dialog = Util.createJOptionDialog(new JOptionPane(ex, 0), ex.getMessage());
            dialog.setVisible(true);
            return;
        }
    }

    public static void copyDeep(File source, File target, File patternsFile) throws IOException {
        CopyFiles copyFiles = new CopyFiles(source, target, patternsFile);
        LOGGER.fine("Copying from: " + copyFiles.sourceRoot + "\nto: " + copyFiles.targetRoot);
        copyFiles.copyFolder(copyFiles.sourceRoot);
    }

    private void copyFolder(File sourceFolder) throws IOException {
        File[] srcChildren = sourceFolder.listFiles();
        if (srcChildren == null) {
            LOGGER.info(sourceFolder + " is not a directory or is invalid.");
            return;
        }
        for (File child : srcChildren) {
            if (child.isDirectory()) {
                this.copyFolder(child);
                continue;
            }
            this.copyFile(child);
        }
    }

    private static String getRelativePath(File root, File file) {
        String result = file.getAbsolutePath().substring(root.getAbsolutePath().length());
        if ((result = result.replace('\\', '/')).startsWith("/") && !result.startsWith("//")) {
            result = result.substring(1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File targetFile) throws IOException {
        CopyFiles.ensureParent(targetFile);
        FileInputStream ins = null;
        OutputStream out = null;
        try {
            ins = new FileInputStream(sourceFile);
            out = new FileOutputStream(targetFile);
            FileUtil.copy((InputStream)ins, (OutputStream)out);
        }
        finally {
            if (ins != null) {
                ((InputStream)ins).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File sourceFile) throws IOException {
        String relativePath = CopyFiles.getRelativePath(this.sourceRoot, sourceFile);
        this.currentProperties = null;
        boolean includeFile = false;
        HashSet<String> includeKeys = new HashSet<String>();
        HashSet<String> excludeKeys = new HashSet<String>();
        for (String pattern : this.includePatterns) {
            if (pattern.contains("#")) {
                includeKeys.addAll(this.matchingKeys(relativePath, pattern));
                continue;
            }
            if (!relativePath.matches(pattern)) continue;
            includeFile = true;
            includeKeys.clear();
            break;
        }
        if (includeFile || !includeKeys.isEmpty()) {
            for (String pattern : this.excludePatterns) {
                if (pattern.contains("#")) {
                    excludeKeys.addAll(this.matchingKeys(relativePath, pattern));
                    continue;
                }
                if (!relativePath.matches(pattern)) continue;
                includeFile = false;
                includeKeys.clear();
                break;
            }
        }
        LOGGER.log(Level.FINEST, "{0}, includeFile={1}, includeKeys={2}, excludeKeys={3}", new Object[]{relativePath, includeFile, includeKeys, excludeKeys});
        if (!includeFile && includeKeys.isEmpty()) {
            return;
        }
        File targetFile = new File(this.targetRoot, relativePath);
        LOGGER.log(Level.FINE, "Path: {0}", relativePath);
        if (includeKeys.isEmpty() && excludeKeys.isEmpty()) {
            CopyFiles.copyFile(sourceFile, targetFile);
        } else {
            if (!includeKeys.isEmpty()) {
                this.currentProperties.keySet().retainAll(includeKeys);
            }
            this.currentProperties.keySet().removeAll(excludeKeys);
            LOGGER.log(Level.FINE, "  Only keys: {0}", this.currentProperties.keySet());
            OutputStream out = null;
            try {
                CopyFiles.ensureParent(targetFile);
                out = new FileOutputStream(targetFile);
                this.currentProperties.store(out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private Set<String> matchingKeys(String relativePath, String propertiesPattern) throws IOException {
        HashSet<String> matchingKeys = new HashSet<String>();
        String[] patterns = propertiesPattern.split("#", 2);
        String filePattern = patterns[0];
        String keyPattern = patterns[1];
        if (relativePath.matches(filePattern)) {
            if (this.currentProperties == null) {
                this.currentProperties = this.getProperties(relativePath);
            }
            for (String key : this.currentProperties.keySet()) {
                if (!key.matches(keyPattern)) continue;
                matchingKeys.add(key);
            }
        }
        return matchingKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditableProperties getProperties(String relativePath) throws IOException {
        EditableProperties properties = new EditableProperties(false);
        InputStream in = null;
        try {
            in = new FileInputStream(new File(this.sourceRoot, relativePath));
            properties.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return properties;
    }

    private static void ensureParent(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Cannot create folder: " + parent.getAbsolutePath());
        }
    }

    private void readPatterns(Reader r) throws IOException {
        String line;
        BufferedReader buf = new BufferedReader(r);
        while ((line = buf.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            if (line.startsWith("include ")) {
                if ((line = line.substring(8)).length() <= 0) continue;
                this.includePatterns.addAll(CopyFiles.parsePattern(line));
                continue;
            }
            if (line.startsWith("exclude ")) {
                if ((line = line.substring(8)).length() <= 0) continue;
                this.excludePatterns.addAll(CopyFiles.parsePattern(line));
                continue;
            }
            throw new IOException("Wrong line: " + line);
        }
    }

    private static Set<String> parsePattern(String pattern) {
        HashSet<String> patterns = new HashSet<String>();
        if (pattern.contains("#")) {
            StringBuilder partPattern = new StringBuilder();
            ParserState state = ParserState.START;
            int blockLevel = 0;
            block6: for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                switch (state) {
                    case START: {
                        if (c == '#') {
                            state = ParserState.IN_KEY_PATTERN;
                            partPattern.append(c);
                            continue block6;
                        }
                        if (c == '(') {
                            state = ParserState.IN_BLOCK;
                            ++blockLevel;
                            partPattern.append(c);
                            continue block6;
                        }
                        if (c == '|') {
                            patterns.add(partPattern.toString());
                            partPattern = new StringBuilder();
                            continue block6;
                        }
                        partPattern.append(c);
                        continue block6;
                    }
                    case IN_KEY_PATTERN: {
                        if (c == '#') {
                            state = ParserState.AFTER_KEY_PATTERN;
                            continue block6;
                        }
                        partPattern.append(c);
                        continue block6;
                    }
                    case AFTER_KEY_PATTERN: {
                        if (c == '|') {
                            state = ParserState.START;
                            patterns.add(partPattern.toString());
                            partPattern = new StringBuilder();
                            continue block6;
                        }
                        assert (false) : "Wrong OptionsExport pattern " + pattern + ". Only format like filePattern1#keyPattern#|filePattern2 is supported.";
                        continue block6;
                    }
                    case IN_BLOCK: {
                        partPattern.append(c);
                        if (c != ')' || --blockLevel != 0) continue block6;
                        state = ParserState.START;
                    }
                }
            }
            patterns.add(partPattern.toString());
        } else {
            patterns.add(pattern);
        }
        return patterns;
    }

    static enum ParserState {
        START,
        IN_KEY_PATTERN,
        AFTER_KEY_PATTERN,
        IN_BLOCK;

    }
}

