/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.util.Collection;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ConditionExpressionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.DeepUtil;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;

public class LoopStatementImpl
extends StatementBase
implements CsmLoopStatement {
    private CsmCondition condition;
    private CsmStatement body;
    private boolean postCheck;

    public LoopStatementImpl(AST aST, CsmFile csmFile, boolean bl, CsmScope csmScope) {
        super(aST, csmFile, csmScope);
        this.postCheck = bl;
    }

    public CsmCondition getCondition() {
        this.renderIfNeed();
        return this.condition;
    }

    public CsmStatement getBody() {
        this.renderIfNeed();
        return this.body;
    }

    public boolean isPostCheck() {
        return this.postCheck;
    }

    public CsmStatement.Kind getKind() {
        return CsmStatement.Kind.WHILE;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.condition instanceof Disposable) {
            ((Disposable)this.condition).dispose();
        }
        if (this.body instanceof Disposable) {
            ((Disposable)this.body).dispose();
        }
    }

    private void renderIfNeed() {
        if (this.condition == null) {
            this.render();
        }
    }

    private void render() {
        AstRenderer astRenderer = new AstRenderer((FileImpl)this.getContainingFile());
        for (AST aST = this.getAst().getFirstChild(); aST != null; aST = aST.getNextSibling()) {
            int n = aST.getType();
            if (n == 536) {
                this.condition = astRenderer.renderCondition(aST, (CsmScope)this);
                continue;
            }
            if (AstRenderer.isExpression(n)) {
                this.condition = new ConditionExpressionImpl(aST, this.getContainingFile(), (CsmScope)this);
                continue;
            }
            if (!AstRenderer.isStatement(n)) continue;
            this.body = AstRenderer.renderStatement(aST, this.getContainingFile(), (CsmScope)this);
        }
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return DeepUtil.merge(this.getCondition(), this.getBody());
    }
}

