/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.RequestProcessor;

public class FakeRegistrationWorker {
    private final RequestProcessor FAKE_REGISTRATION_WORKER = new RequestProcessor("Fake Registration Worker", CndUtils.getNumberCndWorkerThreads());
    private final ProjectBase project;
    private final AtomicBoolean disposing;

    FakeRegistrationWorker(ProjectBase projectBase, AtomicBoolean atomicBoolean) {
        this.project = projectBase;
        this.disposing = atomicBoolean;
    }

    void fixFakeRegistration(boolean bl) {
        Collection<CsmUID<CsmFile>> collection = this.project.getAllFilesUID();
        int n = collection.size();
        int n2 = CndUtils.getNumberCndWorkerThreads() * 3;
        CountDownLatch countDownLatch = new CountDownLatch(n2);
        int n3 = n / n2 + 1;
        Iterator<CsmUID<CsmFile>> iterator = collection.iterator();
        for (int i = 0; i < n2; ++i) {
            ArrayList<CsmUID<CsmFile>> arrayList = new ArrayList<CsmUID<CsmFile>>(n3);
            for (int j = 0; j < n3 && iterator.hasNext(); ++j) {
                arrayList.add(iterator.next());
            }
            FixRegistrationRunnable fixRegistrationRunnable = new FixRegistrationRunnable(countDownLatch, arrayList, bl, this.disposing);
            this.FAKE_REGISTRATION_WORKER.post((Runnable)fixRegistrationRunnable);
        }
        try {
            countDownLatch.await();
            if (bl) {
                this.project.cleanAllFakeFunctionAST();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class FixRegistrationRunnable
    implements Runnable {
        private final CountDownLatch countDownLatch;
        private final List<CsmUID<CsmFile>> files;
        private final boolean libsAlreadyParsed;
        private final AtomicBoolean cancelled;

        private FixRegistrationRunnable(CountDownLatch countDownLatch, List<CsmUID<CsmFile>> list, boolean bl, AtomicBoolean atomicBoolean) {
            this.countDownLatch = countDownLatch;
            this.files = list;
            this.libsAlreadyParsed = bl;
            this.cancelled = atomicBoolean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (CsmUID<CsmFile> csmUID : this.files) {
                    if (this.cancelled.get()) {
                        return;
                    }
                    if (csmUID == null) {
                        return;
                    }
                    FileImpl fileImpl = (FileImpl)UIDCsmConverter.UIDtoFile(csmUID);
                    CndUtils.assertTrueInConsole((fileImpl != null ? 1 : 0) != 0, (String)("no deref file for " + csmUID));
                    if (fileImpl == null) {
                        return;
                    }
                    Thread.currentThread().setName("Fix registration " + csmUID);
                    fileImpl.onProjectParseFinished(this.libsAlreadyParsed);
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

