/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;

public final class ErrorDirectiveImpl
extends OffsetableBase
implements CsmErrorDirective {
    private final CharSequence msg;

    private ErrorDirectiveImpl(CsmFile csmFile, CharSequence charSequence, CsmOffsetable csmOffsetable) {
        super(csmFile, csmOffsetable);
        this.msg = DefaultCache.getManager().getString(charSequence);
    }

    public static ErrorDirectiveImpl create(CsmFile csmFile, CharSequence charSequence, CsmOffsetable csmOffsetable) {
        return new ErrorDirectiveImpl(csmFile, charSequence, csmOffsetable);
    }

    @Override
    public CharSequence getText() {
        return this.msg;
    }

    @Override
    public String toString() {
        return super.toString() + this.msg;
    }

    @Override
    public int hashCode() {
        return 47 * super.hashCode() + this.msg.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ErrorDirectiveImpl errorDirectiveImpl = (ErrorDirectiveImpl)object;
        return this.msg.equals(errorDirectiveImpl.msg);
    }

    public ErrorDirectiveImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.msg = PersistentUtils.readUTF(dataInput, DefaultCache.getManager());
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeUTF(this.msg, dataOutput);
    }
}

