/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.nodes;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.ui.KenaiLoginTask;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class LoginAction
extends AbstractAction {
    private Kenai kenai;
    private PropertyChangeListener l;

    public LoginAction(Kenai kenai) {
        this.kenai = kenai;
        this.l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if ("login".equals(pce.getPropertyName())) {
                    if (pce.getNewValue() == null) {
                        LoginAction.this.setLogout(false);
                    } else {
                        LoginAction.this.setLogout(true);
                    }
                }
            }
        };
        kenai.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.l, (Object)kenai));
        this.setLogout(kenai.getStatus() != Kenai.Status.OFFLINE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.kenai.getStatus() != Kenai.Status.OFFLINE) {
            this.kenai.logout();
        } else if (!UIUtils.showLogin(this.kenai)) {
            return;
        }
    }

    private void setLogout(boolean b) {
        if (b) {
            this.putValue("Name", NbBundle.getMessage(KenaiLoginTask.class, (String)"CTL_LogoutAction"));
        } else {
            this.putValue("Name", NbBundle.getMessage(KenaiLoginTask.class, (String)"CTL_LoginAction"));
        }
    }
}

