/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;

public class LinkButton
extends JButton {
    public LinkButton(Image img, Action a) {
        this(new ImageIcon(img), a);
    }

    public LinkButton(Icon icon, Action a) {
        this.setIcon(icon);
        this.setPressedIcon(icon);
        this.init(a);
    }

    public LinkButton(String text, Icon icon, Action a) {
        super(text);
        this.setIcon(icon);
        this.setPressedIcon(icon);
        Object tooltip = a.getValue("ShortDescription");
        if (null != tooltip) {
            this.setToolTipText(tooltip.toString());
        }
        this.init(a);
    }

    public LinkButton(String text, Action a) {
        super(text);
        if (null != a) {
            Object tooltip;
            Icon icon = (Icon)a.getValue("SmallIcon");
            if (null != icon) {
                this.setIcon(icon);
                this.setPressedIcon(icon);
            }
            if (null != (tooltip = a.getValue("ShortDescription"))) {
                this.setToolTipText(tooltip.toString());
            }
        }
        this.init(a);
    }

    public void setForeground(Color foreground, boolean isSelected) {
        if (isSelected) {
            if (foreground instanceof UIResource) {
                foreground = new Color(foreground.getRGB());
            }
            this.setForeground(foreground);
        } else if (this.isEnabled()) {
            this.setForeground(ColorManager.getDefault().getLinkColor());
        } else {
            this.setForeground(ColorManager.getDefault().getDisabledColor());
        }
    }

    private void init(Action al) {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setFocusable(false);
        this.setContentAreaFilled(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setModel(new Model());
        if (null != al) {
            this.addActionListener(al);
            this.setForeground(ColorManager.getDefault().getLinkColor());
        } else {
            this.setEnabled(false);
            this.setForeground(ColorManager.getDefault().getDisabledColor());
        }
        this.setFont(UIManager.getFont("Tree.font"));
    }

    private static class Model
    extends DefaultButtonModel {
        private Model() {
        }

        @Override
        public boolean isPressed() {
            return false;
        }
    }
}

