/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.filechooser.FileSystemView;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.SourceAndIssuesWizardPanelGUI;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class Utilities {
    private static HashMap<String, Boolean> chatSupported = new HashMap();

    public static File getDefaultRepoFolder() {
        String nbPrjDirName;
        File nbPrjDir;
        File defaultDir = FileSystemView.getFileSystemView().getDefaultDirectory();
        if (defaultDir != null && defaultDir.exists() && defaultDir.isDirectory() && (nbPrjDir = new File(defaultDir, nbPrjDirName = NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"DIR_NetBeansProjects"))).exists() && nbPrjDir.canWrite()) {
            return nbPrjDir;
        }
        return FileUtil.normalizeFile((File)new File(System.getProperty("user.home")));
    }

    public static boolean isChatSupported(Kenai kenai, boolean forceCheck) {
        String kenaiHost = kenai.getUrl().getHost();
        Boolean b = chatSupported.get(kenaiHost);
        if (forceCheck || b == null) {
            b = Boolean.FALSE;
            try {
                for (KenaiService service : kenai.getServices()) {
                    if (service.getType() != KenaiService.Type.CHAT) continue;
                    XMPPConnection xmppConnection = new XMPPConnection(kenai.getUrl().getHost());
                    try {
                        xmppConnection.connect();
                        b = Boolean.TRUE;
                        xmppConnection.disconnect();
                    }
                    catch (XMPPException ex) {}
                    break;
                }
            }
            catch (KenaiException ex) {
                return false;
            }
            chatSupported.put(kenaiHost, b);
        }
        return b;
    }

    public static boolean isChatSupported(Kenai kenai) {
        return Utilities.isChatSupported(kenai, false);
    }

    public static void assertJid(String name) {
        assert (name != null);
        assert (name.contains("@")) : "name must be FQN";
        assert (!name.contains("/")) : "name cannot contain '/'";
    }

    public static Kenai getPreferredKenai() {
        Collection kenais = KenaiManager.getDefault().getKenais();
        Kenai kenai = null;
        for (Kenai k : kenais) {
            if (k.getUrl().getHost().equals("kenai.com")) {
                kenai = k;
            }
            if (!k.getUrl().getHost().endsWith("java.net")) continue;
            return k;
        }
        if (kenai != null) {
            return kenai;
        }
        if (!kenais.isEmpty()) {
            return (Kenai)kenais.iterator().next();
        }
        return null;
    }
}

