/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.beans.PropertyChangeListener;
import org.netbeans.modules.kenai.api.KenaiProjectMember;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.ui.spi.MemberHandle;
import org.openide.util.NbBundle;

public class MemberHandleImpl
extends MemberHandle {
    private KenaiProjectMember delegate;
    private boolean isOwner;

    public MemberHandleImpl(KenaiProjectMember member, boolean isOwner) {
        this.delegate = member;
        this.isOwner = isOwner;
    }

    @Override
    public String getDisplayName() {
        return this.delegate.getKenaiUser().getUserName();
    }

    @Override
    public String getName() {
        return this.delegate.getKenaiUser().getUserName();
    }

    @Override
    public String getRole() {
        KenaiProjectMember.Role r = this.delegate.getRole();
        String result = null;
        if (r != null) {
            switch (r) {
                case ADMIN: {
                    result = NbBundle.getMessage(MemberHandleImpl.class, (String)"Role.Admin");
                    break;
                }
                case DEVELOPER: {
                    result = NbBundle.getMessage(MemberHandleImpl.class, (String)"Role.Developer");
                    break;
                }
                case CONTENT: {
                    result = NbBundle.getMessage(MemberHandleImpl.class, (String)"Role.Content");
                    break;
                }
                case OBSERVER: {
                    result = NbBundle.getMessage(MemberHandleImpl.class, (String)"Role.Observer");
                }
            }
        }
        if (this.isOwner) {
            result = result + ", " + NbBundle.getMessage(MemberHandleImpl.class, (String)"Role.Owner");
        }
        return result;
    }

    @Override
    public boolean hasMessages() {
        return ChatNotifications.getDefault().hasNewPrivateMessages(this.delegate.getKenaiUser().getFQN());
    }

    @Override
    public boolean isOnline() {
        return this.delegate.getKenaiUser().isOnline();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.delegate.getKenaiUser().addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.delegate.getKenaiUser().removePropertyChangeListener(listener);
    }

    @Override
    public String getFullName() {
        return this.delegate.getKenaiUser().getFirstName() + " " + this.delegate.getKenaiUser().getLastName();
    }

    @Override
    public int compareTo(MemberHandle o) {
        MemberHandleImpl other = (MemberHandleImpl)o;
        if (this.isOwner) {
            return -1;
        }
        if (other.isOwner) {
            return 1;
        }
        int res = this.delegate.getRole().compareTo((Enum)other.delegate.getRole());
        if (res == 0) {
            return this.getDisplayName().compareToIgnoreCase(o.getDisplayName());
        }
        return res;
    }

    @Override
    public String getFQN() {
        return this.getName() + "@" + this.delegate.getKenaiUser().getKenai().getUrl().getHost().toString();
    }
}

