/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.ui.GetSourcesFromKenaiPanel;
import org.netbeans.modules.kenai.ui.KenaiTopComponent;
import org.netbeans.modules.kenai.ui.SourceAccessorImpl;
import org.netbeans.modules.kenai.ui.SourceHandleImpl;
import org.netbeans.modules.kenai.ui.spi.SourceHandle;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.modules.mercurial.api.Mercurial;
import org.netbeans.modules.subversion.api.Subversion;
import org.netbeans.modules.versioning.system.cvss.api.CVS;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class GetSourcesFromKenaiAction
extends AbstractAction {
    private SourceAccessorImpl.ProjectAndFeature prjAndFeature;
    private SourceHandleImpl srcHandle;
    private String dialogTitle = NbBundle.getMessage(GetSourcesFromKenaiAction.class, (String)"GetSourcesFromKenaiTitle");
    private String getOption = NbBundle.getMessage(GetSourcesFromKenaiAction.class, (String)"GetSourcesFromKenaiAction.GetFromKenai.option");
    private String cancelOption = NbBundle.getMessage(GetSourcesFromKenaiAction.class, (String)"GetSourcesFromKenaiAction.Cancel.option");

    public GetSourcesFromKenaiAction(SourceAccessorImpl.ProjectAndFeature prjFtr, SourceHandle src) {
        this.prjAndFeature = prjFtr;
        this.srcHandle = (SourceHandleImpl)src;
    }

    public GetSourcesFromKenaiAction() {
        this((SourceAccessorImpl.ProjectAndFeature)null, (SourceHandle)null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.prjAndFeature != null && "external_repository".equals(this.prjAndFeature.feature.getService())) {
            this.tryExternalCheckout(this.prjAndFeature.feature.getLocation());
            return;
        }
        if (this.prjAndFeature != null && "subversion".equals(this.prjAndFeature.feature.getService()) && !Subversion.isClientAvailable((boolean)true)) {
            return;
        }
        Object[] options = new Object[]{this.getOption, this.cancelOption};
        KenaiTopComponent.findInstance().open();
        KenaiTopComponent.findInstance().requestActive();
        GetSourcesFromKenaiPanel getSourcesPanel = new GetSourcesFromKenaiPanel(this.prjAndFeature);
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)getSourcesPanel, this.dialogTitle, true, options, options[0], 0, null, null);
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDesc);
        if (options[0].equals(option)) {
            try {
                final GetSourcesFromKenaiPanel.GetSourcesInfo sourcesInfo = getSourcesPanel.getSelectedSourcesInfo();
                if (sourcesInfo == null) {
                    return;
                }
                final KenaiFeature feature = sourcesInfo.feature;
                final PasswordAuthentication passwdAuth = KenaiProject.forRepository((String)feature.getLocation()).getKenai().getPasswordAuthentication();
                if ("subversion".equals(feature.getService())) {
                    if (Subversion.isClientAvailable((boolean)true)) {
                        UIUtils.logKenaiUsage("KENAI_SVN_CHECKOUT");
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (passwdAuth != null) {
                                        Subversion.checkoutRepositoryFolder((String)feature.getLocation(), (String[])sourcesInfo.relativePaths, (File)new File(sourcesInfo.localFolderPath), (String)passwdAuth.getUserName(), (String)new String(passwdAuth.getPassword()), (boolean)true);
                                    } else {
                                        Subversion.checkoutRepositoryFolder((String)feature.getLocation(), (String[])sourcesInfo.relativePaths, (File)new File(sourcesInfo.localFolderPath), (boolean)true);
                                    }
                                    if (GetSourcesFromKenaiAction.this.srcHandle != null) {
                                        GetSourcesFromKenaiAction.this.srcHandle.refresh();
                                    }
                                }
                                catch (MalformedURLException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                catch (IOException ex) {
                                    if ("SVN client unavailable".equals(ex.getMessage())) {
                                        // empty if block
                                    }
                                }
                            }
                        });
                    }
                } else if ("mercurial".equals(feature.getService())) {
                    UIUtils.logKenaiUsage("KENAI_HG_CLONE");
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (passwdAuth != null) {
                                    Mercurial.cloneRepository((String)feature.getLocation(), (File)new File(sourcesInfo.localFolderPath), (String)"", (String)"", (String)"", (String)passwdAuth.getUserName(), (String)new String(passwdAuth.getPassword()), (boolean)true);
                                } else {
                                    Mercurial.cloneRepository((String)feature.getLocation(), (File)new File(sourcesInfo.localFolderPath), (String)"", (String)"", (String)"", (boolean)true);
                                }
                                if (GetSourcesFromKenaiAction.this.srcHandle != null) {
                                    GetSourcesFromKenaiAction.this.srcHandle.refresh();
                                }
                            }
                            catch (MalformedURLException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                }
            }
            catch (KenaiException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void tryExternalCheckout(String url) {
        block6: {
            try {
                if ("subversion".equals(this.prjAndFeature.externalScmType)) {
                    Subversion.openCheckoutWizard((String)url);
                    return;
                }
                if ("cvs".equals(this.prjAndFeature.externalScmType)) {
                    CVS.openCheckoutWizard((String)url);
                    return;
                }
                if ("mercurial".equals(this.prjAndFeature.externalScmType)) {
                    Mercurial.openCloneWizard((String)url);
                    return;
                }
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(GetSourcesFromKenaiAction.class.getName()).log(Level.INFO, "Cannot checkout external repository " + url, malformedURLException);
            }
            catch (IOException ex) {
                if (!"SVN client unavailable".equals(ex.getMessage())) break block6;
                return;
            }
        }
        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(GetSourcesFromKenaiAction.class, (String)"MSG_ScmNotRecognized", (Object)url), NbBundle.getMessage(GetSourcesFromKenaiAction.class, (String)"MSG_ScmNotRecognizedTitle"), 1);
    }
}

