/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.ui.ProjectAccessorImpl;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class DeleteProjectAction
extends AbstractAction {
    private ProjectHandle project;

    public DeleteProjectAction(ProjectHandle project) {
        super(NbBundle.getMessage(DeleteProjectAction.class, (String)"CTL_DeleteProject"));
        this.project = project;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (0 != JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(ProjectAccessorImpl.class, (String)"LBL_ReallyDelete"), NbBundle.getMessage(ProjectAccessorImpl.class, (String)"LBL_ReallyDeleteTitle", (Object)this.project.getDisplayName()), 0)) {
            return;
        }
        DashboardImpl.getInstance().deletingStarted();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    KenaiProject prj = DeleteProjectAction.this.project.getKenaiProject();
                    prj.delete();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Dashboard.getDefault().removeProject(DeleteProjectAction.this.project);
                            DashboardImpl.getInstance().refreshMemberProjects(false);
                        }
                    });
                }
                catch (KenaiException ex) {
                    block5: {
                        try {
                            final String message = (String)ex.getAsMap().get("message");
                            if (message != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), message, NbBundle.getMessage(ProjectAccessorImpl.class, (String)"LBL_DeleteFailed", (Object)DeleteProjectAction.this.project.getDisplayName()), 0);
                                    }
                                });
                                break block5;
                            }
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DashboardImpl.getInstance().deletingFinished();
                                }
                            });
                            throw throwable;
                        }
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }
}

