/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.filemodels;

import com.sun.javacard.Portability;
import com.sun.javacard.filemodels.FileModelEntry;

public final class WebXmlServletEntry
implements FileModelEntry {
    private final String name;
    private final String clazz;
    private final int order;
    private String mapping;

    public WebXmlServletEntry(String name, String clazz, String mapping, int order) {
        this.name = name;
        this.clazz = clazz;
        this.mapping = mapping;
        this.order = order;
    }

    public String toString() {
        return "Servlet name=" + this.name + " class=" + this.clazz + " mapping=" + this.mapping;
    }

    @Override
    public String getProblem() {
        String key = null;
        if (this.name == null || this.name.trim().length() == 0) {
            key = "PROBLEM_NO_NAME";
        } else if (this.name != null && this.name.trim().indexOf(32) >= 0) {
            key = "PROBLEM_NAME_CONTAINS_SPACES";
        } else if (this.mapping == null || this.mapping.trim().length() == 0) {
            key = "PROBLEM_MAPPING_NOT_SET";
        } else if (this.mapping != null && this.mapping.trim().indexOf(32) >= 0) {
            key = "PROBLEM_MAPPING_CONTAINS_SPACES";
        } else if (this.mapping != null && !this.mapping.startsWith("/")) {
            key = "PROBLEM_MAPPING_DOESNT_START_WITH_SLASH";
        }
        if (key != null) {
            return Portability.getString(key, this.trimmedClassName());
        }
        return null;
    }

    private String trimmedClassName() {
        if (this.clazz == null) {
            return "???";
        }
        int ix = this.clazz.lastIndexOf(".");
        if (ix != this.clazz.length() - 1) {
            return this.clazz.substring(ix + 1);
        }
        return this.clazz;
    }

    @Override
    public String toXml() {
        StringBuilder sb = new StringBuilder("\n    <servlet>\n         <servlet-name>");
        sb.append(this.name);
        sb.append("</servlet-name>\n");
        sb.append("         <servlet-class>");
        sb.append(this.clazz);
        sb.append("</servlet-class>\n    </servlet>\n");
        sb.append("    <servlet-mapping>\n        <servlet-name>");
        sb.append(this.name);
        sb.append("</servlet-name>\n        <url-pattern>");
        sb.append(this.mapping);
        sb.append("</url-pattern>\n    </servlet-mapping>\n\n");
        return sb.toString();
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebXmlServletEntry other = (WebXmlServletEntry)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
            return false;
        }
        return !(this.mapping == null ? other.mapping != null : !this.mapping.equals(other.mapping));
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 47 * hash + (this.clazz != null ? this.clazz.hashCode() : 0);
        hash = 47 * hash + (this.mapping != null ? this.mapping.hashCode() : 0);
        return hash;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.clazz;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    @Override
    public int compareTo(FileModelEntry o) {
        assert (o == null || o.getClass() == this.getClass());
        return this.getOrder() - o.getOrder();
    }
}

