/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LocalePanel
extends JPanel {
    private Locale locale;
    public static final String PROP_CUSTOMIZED_LOCALE = "customized_locale";
    private static final Locale[] supportedLocales = new Locale[]{new Locale("ar", "AE", ""), new Locale("ar", "BH", ""), new Locale("ar", "DZ", ""), new Locale("ar", "EG", ""), new Locale("ar", "IQ", ""), new Locale("ar", "JO", ""), new Locale("ar", "KW", ""), new Locale("ar", "LB", ""), new Locale("ar", "LY", ""), new Locale("ar", "MA", ""), new Locale("ar", "OM", ""), new Locale("ar", "QA", ""), new Locale("ar", "SA", ""), new Locale("ar", "SD", ""), new Locale("ar", "SY", ""), new Locale("ar", "TN", ""), new Locale("ar", "YE", ""), new Locale("be", "BY", ""), new Locale("bg", "BG", ""), new Locale("ca", "ES", ""), new Locale("cs", "CZ", ""), new Locale("da", "DK", ""), new Locale("de", "AT", ""), new Locale("de", "AT", "EURO"), new Locale("de", "CH", ""), new Locale("de", "DE", ""), new Locale("de", "DE", "EURO"), new Locale("de", "LU", ""), new Locale("de", "LU", "EURO"), new Locale("el", "GR", ""), new Locale("en", "AU", ""), new Locale("en", "CA", ""), new Locale("en", "GB", ""), new Locale("en", "IE", ""), new Locale("en", "IE", "EURO"), new Locale("en", "NZ", ""), new Locale("en", "US", ""), new Locale("en", "ZA", ""), new Locale("es", "AR", ""), new Locale("es", "BO", ""), new Locale("es", "CL", ""), new Locale("es", "CO", ""), new Locale("es", "CR", ""), new Locale("es", "DO", ""), new Locale("es", "EC", ""), new Locale("es", "ES", ""), new Locale("es", "ES", "EURO"), new Locale("es", "GT", ""), new Locale("es", "HN", ""), new Locale("es", "MX", ""), new Locale("es", "NI", ""), new Locale("es", "PA", ""), new Locale("es", "PE", ""), new Locale("es", "PR", ""), new Locale("es", "PY", ""), new Locale("es", "SV", ""), new Locale("es", "UY", ""), new Locale("es", "VE", ""), new Locale("et", "EE", ""), new Locale("fi", "FI", ""), new Locale("fi", "FI", "EURO"), new Locale("fr", "BE", ""), new Locale("fr", "BE", "EURO"), new Locale("fr", "CA", ""), new Locale("fr", "CH", ""), new Locale("fr", "FR", ""), new Locale("fr", "FR", "EURO"), new Locale("fr", "LU", ""), new Locale("fr", "LU", "EURO"), new Locale("hr", "HR", ""), new Locale("hu", "HU", ""), new Locale("is", "IS", ""), new Locale("it", "CH", ""), new Locale("it", "IT", ""), new Locale("it", "IT", "EURO"), new Locale("iw", "IL", ""), new Locale("ja", "JP", ""), new Locale("ko", "KR", ""), new Locale("lt", "LT", ""), new Locale("lv", "LV", ""), new Locale("mk", "MK", ""), new Locale("nl", "BE", ""), new Locale("nl", "BE", "EURO"), new Locale("nl", "NL", ""), new Locale("nl", "NL", "EURO"), new Locale("no", "NO", ""), new Locale("no", "NO", "B"), new Locale("pl", "PL", ""), new Locale("pt", "BR", ""), new Locale("pt", "PT", ""), new Locale("pt", "PT", "EURO"), new Locale("ro", "RO", ""), new Locale("ru", "RU", ""), new Locale("sh", "YU", ""), new Locale("sk", "SK", ""), new Locale("sl", "SI", ""), new Locale("sq", "AL", ""), new Locale("sr", "YU", ""), new Locale("sv", "SE", ""), new Locale("th", "TH", ""), new Locale("tr", "TR", ""), new Locale("uk", "UA", ""), new Locale("vi", "VN", ""), new Locale("zh", "CN", ""), new Locale("zh", "HK", ""), new Locale("zh", "TW", "")};
    private JComboBox countryCombo;
    private JLabel countryLabel;
    private JScrollPane jScrollPane1;
    private JComboBox languageCombo;
    private JLabel languageLabel;
    private JLabel localeLabel;
    private JTextField localeText;
    private JLabel supportedLabel;
    private JList supportedList;
    private JComboBox variantCombo;
    private JLabel variantLabel;

    public LocalePanel() {
        this(new Locale("", "", ""));
    }

    public LocalePanel(Locale locale) {
        this.locale = locale;
        this.initComponents();
        this.initAccessibility();
        this.languageCombo.setSelectedItem(locale.getLanguage());
        this.countryCombo.setSelectedItem(locale.getCountry());
        this.variantCombo.setSelectedItem(locale.getVariant());
        this.localeText.setText(locale.toString());
        HelpCtx.setHelpIDString((JComponent)this, (String)"propfiles.addlocale");
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocalePanel.class).getString("ACS_LocalePanel"));
        this.localeText.getAccessibleContext().setAccessibleName(NbBundle.getBundle(LocalePanel.class).getString("ACS_CTL_LocaleText"));
        this.localeText.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocalePanel.class).getString("ACS_CTL_LocaleText"));
        this.countryCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocalePanel.class).getString("ACS_CTL_CountryCombo"));
        this.languageCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocalePanel.class).getString("ACS_CTL_LanguageCombo"));
        this.supportedList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocalePanel.class).getString("ACS_CTL_SupportedList"));
        this.variantCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocalePanel.class).getString("ACS_CTL_VariantCombo"));
    }

    private void initComponents() {
        this.languageLabel = new JLabel();
        this.languageCombo = new JComboBox<String>(Locale.getISOLanguages());
        this.countryLabel = new JLabel();
        this.countryCombo = new JComboBox<String>(Locale.getISOCountries());
        this.variantLabel = new JLabel();
        this.variantCombo = new JComboBox<String>(new String[]{"B", "EURO", "NY"});
        this.supportedLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.supportedList = new JList<Locale>(supportedLocales);
        this.localeLabel = new JLabel();
        this.localeText = new JTextField();
        this.languageLabel.setLabelFor(this.languageCombo);
        Mnemonics.setLocalizedText((JLabel)this.languageLabel, (String)NbBundle.getBundle(LocalePanel.class).getString("CTL_LanguageCode"));
        this.languageCombo.setEditable(true);
        this.languageCombo.setRenderer(new NbBasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if ("".equals(value.toString())) {
                    label.setText("");
                } else {
                    label.setText(value.toString() + " - " + new Locale((String)value, "", "").getDisplayLanguage());
                }
                return label;
            }
        });
        this.languageCombo.insertItemAt("", 0);
        this.languageCombo.setSelectedIndex(0);
        this.languageCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalePanel.this.languageComboActionPerformed(evt);
            }
        });
        this.countryLabel.setLabelFor(this.countryCombo);
        Mnemonics.setLocalizedText((JLabel)this.countryLabel, (String)NbBundle.getBundle(LocalePanel.class).getString("CTL_CountryCode"));
        this.countryCombo.setEditable(true);
        this.countryCombo.setRenderer(new NbBasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if ("".equals(value.toString())) {
                    label.setText("");
                } else {
                    label.setText(value.toString() + " - " + new Locale("", (String)value, "").getDisplayCountry());
                }
                return label;
            }
        });
        this.countryCombo.insertItemAt("", 0);
        this.countryCombo.setSelectedIndex(0);
        this.countryCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalePanel.this.countryComboActionPerformed(evt);
            }
        });
        this.variantLabel.setLabelFor(this.variantCombo);
        Mnemonics.setLocalizedText((JLabel)this.variantLabel, (String)NbBundle.getBundle(LocalePanel.class).getString("CTL_Variant"));
        this.variantCombo.setEditable(true);
        this.variantCombo.setRenderer(new NbBasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if ("".equals(value.toString())) {
                    label.setText("");
                } else {
                    label.setText(value.toString() + " - " + new Locale("", "", (String)value).getDisplayVariant());
                }
                return label;
            }
        });
        this.variantCombo.insertItemAt("", 0);
        this.variantCombo.setSelectedIndex(0);
        this.variantCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalePanel.this.variantComboActionPerformed(evt);
            }
        });
        this.supportedLabel.setLabelFor(this.supportedList);
        Mnemonics.setLocalizedText((JLabel)this.supportedLabel, (String)NbBundle.getBundle(LocalePanel.class).getString("CTL_SupportedLocales"));
        this.supportedList.setSelectionMode(0);
        this.supportedList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Locale locale = (Locale)value;
                label.setText(locale.toString() + (locale.getLanguage().equals("") ? "" : " - " + locale.getDisplayLanguage()) + (locale.getCountry().equals("") ? "" : " / " + locale.getDisplayCountry()) + (locale.getVariant().equals("") ? "" : " / " + locale.getDisplayVariant()));
                return label;
            }
        });
        this.supportedList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LocalePanel.this.supportedListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.supportedList);
        this.localeLabel.setLabelFor(this.localeText);
        Mnemonics.setLocalizedText((JLabel)this.localeLabel, (String)NbBundle.getMessage(LocalePanel.class, (String)"CTL_Locale"));
        this.localeText.setEditable(false);
        this.localeText.selectAll();
        this.localeText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                LocalePanel.this.localeTextFocusGained(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.localeLabel).add((Component)this.languageLabel).add((Component)this.countryLabel).add((Component)this.variantLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.languageCombo, 0, 297, Short.MAX_VALUE).add((Component)this.countryCombo, 0, 297, Short.MAX_VALUE).add((Component)this.variantCombo, 0, 297, Short.MAX_VALUE).add((Component)this.localeText, -1, 297, Short.MAX_VALUE))).add((Component)this.jScrollPane1, -1, 408, Short.MAX_VALUE).add((Component)this.supportedLabel)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.localeLabel).add((Component)this.localeText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.languageLabel).add((Component)this.languageCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.countryLabel).add((Component)this.countryCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.variantLabel).add((Component)this.variantCombo, -2, -1, -2)).add(17, 17, 17).add((Component)this.supportedLabel).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 128, Short.MAX_VALUE).addContainerGap()));
    }

    private void localeTextFocusGained(FocusEvent evt) {
        this.localeText.selectAll();
    }

    private void supportedListValueChanged(ListSelectionEvent evt) {
        Locale selectedLocale = (Locale)this.supportedList.getSelectedValue();
        if (selectedLocale != null) {
            this.languageCombo.setSelectedItem(selectedLocale.getLanguage());
            this.countryCombo.setSelectedItem(selectedLocale.getCountry());
            this.variantCombo.setSelectedItem(selectedLocale.getVariant());
        }
        this.supportedList.ensureIndexIsVisible(this.supportedList.getSelectedIndex());
    }

    private void variantComboActionPerformed(ActionEvent evt) {
        this.comboHandler(evt);
    }

    private void countryComboActionPerformed(ActionEvent evt) {
        this.comboHandler(evt);
    }

    private void languageComboActionPerformed(ActionEvent evt) {
        this.comboHandler(evt);
    }

    private void comboHandler(ActionEvent evt) {
        String str = (String)((JComboBox)evt.getSource()).getSelectedItem();
        Locale oldLocale = this.locale;
        Object source = evt.getSource();
        if (source.equals(this.languageCombo)) {
            if (str.equals(this.locale.getLanguage())) {
                return;
            }
            this.locale = new Locale(str, this.locale.getCountry(), this.locale.getVariant());
        } else if (source.equals(this.countryCombo)) {
            if (str.equals(this.locale.getCountry())) {
                return;
            }
            this.locale = new Locale(this.locale.getLanguage(), str, this.locale.getVariant());
        } else if (source.equals(this.variantCombo)) {
            if (str.equals(this.locale.getVariant())) {
                return;
            }
            this.locale = new Locale(this.locale.getLanguage(), this.locale.getCountry(), str);
        }
        this.localeText.setText(this.locale.toString());
        this.firePropertyChange(PROP_CUSTOMIZED_LOCALE, oldLocale, this.locale);
    }

    private static abstract class NbBasicComboBoxRenderer
    extends BasicComboBoxRenderer.UIResource {
        private NbBasicComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

