/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.resolver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.system.resolver.StringResolver;

public class FieldResolver
implements StringResolver {
    public String resolve(String string, ClassLoader loader) {
        String parsed = string;
        Matcher matcher = Pattern.compile("(?<!\\\\)\\$F\\{((?:[a-zA-Z_][a-zA-Z_0-9]*\\.)+[a-zA-Z_][a-zA-Z_0-9]*)\\.([a-zA-Z_][a-zA-Z_0-9]*)\\}").matcher(parsed);
        while (matcher.find()) {
            String classname = matcher.group(1);
            String fieldname = matcher.group(2);
            try {
                Object object = loader.loadClass(classname).getField(fieldname).get(null);
                if (object == null) continue;
                String value = object.toString();
                parsed = parsed.replace(matcher.group(), value);
            }
            catch (IllegalArgumentException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
            catch (SecurityException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
            catch (ClassNotFoundException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
            catch (IllegalAccessException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
            catch (NoSuchFieldException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
        }
        return parsed;
    }
}

