/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.FolderImpl;
import org.netbeans.modules.cnd.discovery.api.FolderProperties;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Utilities;

public final class ProjectImpl
implements ProjectProperties {
    private static boolean gatherFolders = true;
    private ItemProperties.LanguageKind language;
    private Set<String> userIncludes = new LinkedHashSet<String>();
    private Set<String> systemIncludes = new LinkedHashSet<String>();
    private Map<String, String> userMacros = new HashMap<String, String>();
    private Map<String, FolderProperties> folders = new HashMap<String, FolderProperties>();

    public ProjectImpl(ItemProperties.LanguageKind language) {
        this.language = language;
    }

    public void update(SourceFileProperties source) {
        this.userIncludes.addAll(source.getUserInludePaths());
        for (String path : source.getUserInludePaths()) {
            this.userIncludes.add(DiscoveryUtils.convertRelativePathToAbsolute(source, path));
        }
        this.userMacros.putAll(source.getUserMacros());
        if (gatherFolders) {
            this.updateFolder(source);
        }
    }

    public static List<ProjectProperties> divideByLanguage(List<SourceFileProperties> sources) {
        ProjectImpl cProp = null;
        ProjectImpl cppProp = null;
        for (SourceFileProperties source : sources) {
            ItemProperties.LanguageKind lang = source.getLanguageKind();
            ProjectImpl current = null;
            if (lang == ItemProperties.LanguageKind.C) {
                if (cProp == null) {
                    cProp = new ProjectImpl(lang);
                }
                current = cProp;
            } else {
                if (cppProp == null) {
                    cppProp = new ProjectImpl(lang);
                }
                current = cppProp;
            }
            current.update(source);
        }
        ArrayList<ProjectProperties> languages = new ArrayList<ProjectProperties>();
        if (cProp != null) {
            languages.add(cProp);
        }
        if (cppProp != null) {
            languages.add(cppProp);
        }
        return languages;
    }

    private void updateFolder(SourceFileProperties source) {
        FolderProperties folder;
        File file = new File(source.getItemPath());
        String path = CndFileUtils.normalizeFile((File)file.getParentFile()).getAbsolutePath();
        if (Utilities.isWindows()) {
            path = path.replace('\\', '/');
        }
        if ((folder = this.folders.get(path)) == null) {
            this.folders.put(path, new FolderImpl(path, source));
        } else {
            ((FolderImpl)folder).update(source);
        }
    }

    @Override
    public List<FolderProperties> getConfiguredFolders() {
        return new ArrayList<FolderProperties>(this.folders.values());
    }

    @Override
    public String getMakePath() {
        return null;
    }

    @Override
    public String getBinaryPath() {
        return null;
    }

    @Override
    public ProjectProperties.BinaryKind getBinaryKind() {
        return null;
    }

    @Override
    public List<String> getUserInludePaths() {
        return new ArrayList<String>(this.userIncludes);
    }

    @Override
    public List<String> getSystemInludePaths() {
        return new ArrayList<String>(this.systemIncludes);
    }

    @Override
    public Map<String, String> getUserMacros() {
        return this.userMacros;
    }

    @Override
    public Map<String, String> getSystemMacros() {
        return null;
    }

    @Override
    public ItemProperties.LanguageKind getLanguageKind() {
        return this.language;
    }

    @Override
    public String getCompilerName() {
        return "";
    }
}

