/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import java.io.IOException;
import java.util.ArrayList;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.reader.ErrorReader;
import org.rubyforge.debugcommons.reader.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ThreadInfoReader
extends XmlStreamReader {
    private RubyThreadInfo[] threads;

    public ThreadInfoReader(XmlPullParser xpp) {
        super(xpp);
    }

    private void parse() throws XmlPullParserException, IOException {
        ArrayList<RubyThreadInfo> _threads = new ArrayList<RubyThreadInfo>();
        assert (this.xpp.getName().equals("threads"));
        while (this.nextEvent() != 3 || !"threads".equals(this.xpp.getName())) {
            ErrorReader.flushPossibleMessage(this.xpp);
            if (Util.isEndTag(this.xpp, "threads")) break;
            assert (this.xpp.getName().equals("thread")) : this.xpp.getName() + " encountered";
            int id = this.getAttributeIntValue("id");
            String status = this.getAttributeValue("status");
            RubyThreadInfo info = new RubyThreadInfo(id, status);
            _threads.add(info);
            this.ensureEndTag("thread");
        }
        this.threads = _threads.toArray(new RubyThreadInfo[_threads.size()]);
    }

    public static RubyThreadInfo[] readThreads(XmlPullParser xpp) throws IOException, XmlPullParserException {
        ThreadInfoReader reader = new ThreadInfoReader(xpp);
        reader.parse();
        return reader.threads;
    }
}

