/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class RepositorySourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation {
    public SourceForBinaryQuery.Result findSourceRoots(URL url) {
        File parentParent;
        File parent;
        File jarFile;
        URL binRoot = url;
        if (!"jar".equals(url.getProtocol())) {
            return null;
        }
        binRoot = FileUtil.getArchiveFile((URL)url);
        FileObject jarFO = URLMapper.findFileObject((URL)binRoot);
        if (jarFO != null && (jarFile = FileUtil.toFile((FileObject)jarFO)) != null && (parent = jarFile.getParentFile()) != null && (parentParent = parent.getParentFile()) != null) {
            String artifact = parentParent.getName();
            String version = parent.getName();
            File srcs = new File(parent, artifact + "-" + version + "-sources.jar");
            if (srcs.exists()) {
                return new SrcResult(srcs);
            }
        }
        return null;
    }

    private class SrcResult
    implements SourceForBinaryQuery.Result {
        private static final String ATTR_PATH = "lastRootCheckPath";
        private static final String ATTR_STAMP = "lastRootCheckStamp";
        private File file;
        private final List<ChangeListener> listeners;

        public SrcResult(File src) {
            this.file = src;
            this.listeners = new ArrayList<ChangeListener>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        public FileObject[] getRoots() {
            FileObject fo;
            FileObject jarRoot;
            if (this.file.exists() && (jarRoot = FileUtil.getArchiveRoot((FileObject)(fo = FileUtil.toFileObject((File)this.file)))) != null) {
                Date date = (Date)fo.getAttribute(ATTR_STAMP);
                String path = (String)fo.getAttribute(ATTR_PATH);
                if (date == null || fo.lastModified().after(date)) {
                    path = this.checkPath(jarRoot, fo);
                }
                FileObject[] fos = new FileObject[1];
                if (path != null) {
                    fos[0] = jarRoot.getFileObject(path);
                }
                if (fos[0] == null) {
                    fos[0] = jarRoot;
                }
                return fos;
            }
            return new FileObject[0];
        }

        private String checkPath(FileObject jarRoot, FileObject fo) {
            String toRet = null;
            FileObject root = JavadocAndSourceRootDetection.findSourceRoot((FileObject)jarRoot);
            try {
                if (root != null && !root.equals(jarRoot)) {
                    toRet = FileUtil.getRelativePath((FileObject)jarRoot, (FileObject)root);
                    fo.setAttribute(ATTR_PATH, (Object)toRet);
                }
                fo.setAttribute(ATTR_STAMP, (Object)new Date());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return toRet;
        }
    }
}

